<?php $__env->startSection('content'); ?>

<!-- Current users -->

<div class="page-content d-flex align-items-center justify-content-center">

    <div class="row w-100 mr-5 auth-page">
        <div class="col-md-8 col-xl-8 mx-auto">
            <div class="card">
                <div class="card-body">
                    <div class="btn-group mr-2 mb-sm-0 float-sm-right mt-1">
                        <a href="user/create" role="button"
                            class="btn btn-sm btn-outline-info waves-light waves-effect"><i
                                class="ri-add-circle-line align-middle mr-2"></i>Add User</a>
                    </div>

                    <h4>Users </h4>

                    <table class="table table-striped mt-5" id="dataTable">
                        <?php if(count($users) > 0): ?>

                        <!-- Table Headings -->
                        <thead>
                            <th>Name</th>
                            <th>Surname</th>
                            <th>Email Address</th>
                            <th>Enterprise</th>
                            <th>Action</th>
                        </thead>

                        <!-- Table Body -->
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <!-- Name -->
                                <td class="table-text">
                                    <div><?php echo e($user->name); ?></div>
                                </td>

                                <!-- Surname -->
                                <td class="table-text">
                                    <div><?php echo e($user->surname); ?></div>
                                </td>

                                <!-- User Email Address -->
                                <td class="table-text">
                                    <div><?php echo e($user->email); ?></div>
                                </td>

                                <!-- Enterprise ID -->
                                <td class="table-text">
                                    <?php $__currentLoopData = $eids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $eid): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($eid['id'] == $user->eid_id): ?>
                                    <option value="<?php echo e($eid->id); ?>"><?php echo e($eid->enterprise_id); ?></option>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>

                                <td>
                                    <div>
                                        <a href="<?php echo URL::route('editUser',[$user->id,
                                                 'enterprise_id' => $user->eid_id]); ?>"
                                            class="btn btn-sm btn-info mt-n2"><i
                                                class="ri-edit-2-line mr-1"></i>Edit</a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <?php else: ?>
                        <div class="alert alert-info mt-5" role="alert">No users are available</div>
                        <?php endif; ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('plugin-scripts'); ?>
<script src="<?php echo e(URL::asset('/assets/js/pages/fontawesome.init.js')); ?>"></script>
<script src="<?php echo e(asset('/assets/js/pages/fontawesome.init.js')); ?>"></script>
<link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
<link type="text/css" rel="stylesheet" href="<?php echo e(mix('css/app.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('custom-scripts'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vetsoft/resources/views/user/index.blade.php ENDPATH**/ ?>