<!-- app/views/eid/index.blade.php -->



<?php $__env->startSection('content'); ?>
    <!-- List EID Form... -->

    <!-- Current EID -->

    <div class="page-content d-flex align-items-center justify-content-center">

        <div class="row w-100 mr-5 auth-page">
            <div class="col-md-8 col-xl-8 mx-auto">
                <div class="card">
                    <div class="card-body">
                        <div class="btn-group mr-2 mb-sm-0 float-sm-right mt-1">
                            <a href="eid/create" role="button"
                               class="btn btn-sm btn-outline-info waves-light waves-effect"><i
                                        class="ri-add-circle-line align-middle mr-2"></i>Add Enterprise</a>
                        </div>

                        <h4 class="mb-3">Current Enterprise ID's</h4>

                        <table class="table table-striped" id="dataTable">
                        <?php if(count($eids) > 0): ?>

                            <!-- Table Headings -->
                            <thead>
                                <th width="25%">Name</th>
                                <th width="25%">Enterprise ID</th>
                                <th width="25%">Schema Name</th>
                                <th width="*">Action</th>
                            </thead>

                            <!-- Table Body -->
                            <tbody>
                                <?php $__currentLoopData = $eids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $eid): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <!-- EID Name -->
                                        <td class="table-text">
                                            <div><?php echo e($eid->name); ?></div>
                                        </td>

                                        <!-- Enterprise ID -->
                                        <td class="table-text">
                                            <div><?php echo e($eid->enterprise_id); ?></div>
                                        </td>

                                        <!-- Schema Name -->
                                        <td class="table-text">
                                            <div><?php echo e($eid->schemaName); ?></div>
                                        </td>

                                        <td>
                                            <div>
                                                <?php echo Form::model($eid, ['method' => 'GET', 'route' => ['editEID', $eid->id]]); ?>

                                                <button type="submit" class="btn btn-sm btn-info mt-n2"><i
                                                            class="ri-edit-2-line"></i>
                                                    Edit </button>
                                                <a href="<?php echo URL::route('destroyEID', ['id' => $eid->id]); ?>"
                                                   class="btn btn-sm btn-danger mt-n2"
                                                   onclick="return confirm('Are you sure about deleting the EID?');"><i
                                                            class="ri-delete-bin-6-line mr-1"></i>Delete</a>
                                                <?php echo Form::close(); ?>

                                            </div>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        <?php else: ?>
                            <div class="alert alert-info" role="alert">No Enterprises are available</div>
                        <?php endif; ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vetsoft/resources/views/eid/index.blade.php ENDPATH**/ ?>