<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\EIDController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\Report2Controller;
use App\Http\Controllers\ErrorController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

// show the comming soon page
//Route::get('error/comingsoon', 'App\Http\Controllers\ErrorController@index');
Route::get('error/comingsoon', [ErrorController::class, 'index'])->name('error.comingsoon');

// show the login 2 for testing page
Route::get('login2', [ErrorController::class, 'index'])->name('user.login2');


// show the login form
Route::get('login', [UserController::class, 'showLogin'])->name('login');

// process the login form
Route::post('login', array(UserController::class, 'doLogin'))->name('login');

// process the logout
Route::get('users/logout', [UserController::class, 'doLogout'])->name('logout');

// route to list eids
Route::get('eids', [EIDController::class, 'index'])->name('eids');

// add eid
Route::get('eid/create', [EIDController::class, 'create'])->name('createEID');

// store eid
Route::post('eid/store', [EIDController::class, 'store'])->name('storeEID');

// edit eidEID
Route::get('eid/edit/{id}', [EIDController::class, 'edit'])->name('editEID');

// update user
Route::PATCH('eid/update/{id}', [EIDController::class, 'update'])->name('updateEID');

// delete user
Route::get('eid/destroy/{id}', [EIDController::class, 'destroy'])->name('destroyEID');

// route to list users
Route::get('users', [UserController::class, 'index'])->name('users');

// add user
Route::get('user/create', [UserController::class, 'create'])->name('createUser');

// store user
Route::post('user/store', [UserController::class, 'store'])->name('storeUser');

// edit user
Route::get('user/edit/{id}', [UserController::class, 'edit'])->name('editUser');

// update user
Route::PATCH('user/update/{id}', [UserController::class, 'update'])->name('updateUser');

// delete user
Route::get('user/destroy/{id}', [UserController::class, 'destroy'])->name('destroyUser');

// route to display dashboard
Route::get('dashboard/{id}', [DashboardController::class, 'index'])->name('dashboard');

// route to draw chart
Route::get('chart-line-ajax', [DashboardController::class, 'chartLineAjax'])->name('chart');

// route to search daily stock
Route::get('report/DailyStockTracker', [ReportController::class, 'DailyStockTracker'])->name('DailyStockTracker');

// route to display daily stock summary
Route::get('report/DailyStockReport', [ReportController::class, 'DailyStockReport'])->name('DailyStockReport');

// route to search stock sales
Route::get('report/SalesByType', [ReportController::class, 'searchSalesByType'])->name('SalesByType');

// route to display stock sales summary
Route::get('report/SalesReportByType', [ReportController::class, 'salesTypeSummary'])->name('SalesReportByType');

Route::get('report/LowSales', [ReportController::class, 'searchLowSales'])->name('LowSales');

// route to display stock sales summary
Route::get('report/LowSalesReport', [ReportController::class, 'lowSalesSummary'])->name('LowSalesReport');

// route to display VAT report by date
Route::get('report/VAT', [ReportController::class, 'VATReport'])->name('VAT');

// route to search VAT report by date
Route::get('report/VATReport', [ReportController::class, 'VATSummary'])->name('VATReport');

// route to display VAT report by date
Route::get('report/UserSales', [ReportController::class, 'UserSales'])->name('UserSales');

// route to search VAT report by date
Route::post('report/UserSalesReport', [ReportController::class, 'UserSalesReport'])->name('UserSalesReport');

// get the codes for the selected stock type
Route::get('ajax-type-code/{id}', [ReportController::class, 'ajaxCodes']);

// route to search scheduled drugs
Route::get('report/ScheduledDrugs', [ReportController::class, 'scheduledDrugs'])->name('ScheduledDrugs');

// route to display scheduled drugs
Route::get('report/ScheduledDrugsReport', [ReportController::class, 'scheduledDrugsReport'])->name('ScheduledDrugsReport');

// route to search new clients
Route::get('report/NewClients', [Report2Controller::class, 'newClients'])->name('NewClients');

// route to display scheduled drugs
Route::get('report/NewClientsReport', [Report2Controller::class, 'newClientsReport'])->name('NewClientsReport');

// route to search debtors analysis
Route::get('report/DebtorsAge', [Report2Controller::class, 'debtorsAge'])->name('DebtorsAge');

// route to display scheduled drugs
Route::get('report/DebtorsAgeAnalysis', [Report2Controller::class, 'debtorsAgeAnalysis'])->name('DebtorsAgeAnalysis');

// route to search last seen clients
Route::get('report/LastSeen', [Report2Controller::class, 'lastSeen'])->name('LastSeen');

// route to display last seen client
Route::get('report/LastSeenReport', [Report2Controller::class, 'lastSeenClientReport'])->name('LastSeenReport');

// route to search average consult
Route::get('report/AverageConsult', [Report2Controller::class, 'averageConsult'])->name('AverageConsult');

// route to display average consult
Route::get('report/AverageConsultsByVet', [Report2Controller::class, 'averageConsultsByVet'])->name('AverageConsultsByVet');

// route to display breakdown of the total
Route::get('report/AverageConsultsBreakdown', [Report2Controller::class, 'averageConsultsBreakdown'])
    ->name('AverageConsultsBreakdown');

// route to search individual stock item
Route::get('report/IndividualStock', [Report2Controller::class, 'individualStock'])->name('IndividualStock');

// route to display individual stock item report
Route::get('report/IndividualStockItem', [Report2Controller::class, 'stockItemUsage'])->name('IndividualStockItem');

// route to search reprint till ledger
Route::get('report/ReprintTill', [Report2Controller::class, 'reprintTill'])->name('ReprintTill');

// route to display reprint till ledger
Route::get('report/ReprintTillLedger', [Report2Controller::class, 'tillLedger'])->name('ReprintTillLedger');

// route to search banking summary
Route::get('report/BankingSummary', [Report2Controller::class, 'bankingSummary'])->name('BankingSummary');

// route to display banking summary report
Route::get('report/BankingSummaryReport', [Report2Controller::class, 'bankingSummaryReport'])->name('BankingSummaryReport');

// route to search client information
Route::get('report/ClientInfo', [Report2Controller::class, 'clientInformation'])->name('ClientInfo');

// route to display banking summary report
Route::get('report/ClientInfoReport', [Report2Controller::class, 'clientInformationReport'])->name('ClientInfoReport');

// route to display selection list
Route::get('report/UserTravel', [Report2Controller::class, 'userTravel'])->name('UserTravel');

// route to search per type
Route::get('report/TravelPerType', [Report2Controller::class, 'travelPerType'])->name('TravelPerType');

// route to search per user
Route::get('report/TravelPerCode', [Report2Controller::class, 'travelPerCode'])->name('TravelPerCode');

// route to display travel details per user
Route::get('report/UserTravelReport', [Report2Controller::class, 'userTravelReport'])->name('UserTravelReport');

// route to display user travel details
Route::get('report/UserTravelReport2', [Report2Controller::class, 'userTravelReport2'])->name('UserTravelReport2');

// route to search per user
Route::get('report/StockValuation', [Report2Controller::class, 'stockValuation'])->name('StockValuation');

// route to display travel details per user
Route::get('report/StockValuationReport', [Report2Controller::class, 'stockValuationReport'])->name('StockValuationReport');

// route to search patient flag
Route::get('report/PatientFlag', [Report2Controller::class, 'patientFlag'])->name('PatientFlag');

// route to display travel details per user
Route::get('report/PatientFlagReport', [Report2Controller::class, 'patientFlagReport'])->name('PatientFlagReport');

// route to search discount client
Route::get('report/ClientDiscount', [Report2Controller::class, 'clientDiscount'])->name('ClientDiscount');

// route to display client discount report
Route::get('report/ClientDiscountReport', [Report2Controller::class, 'clientDiscReport'])->name('ClientDiscountReport');

// route to search total consultations
Route::get('report/TotalConsultations', [Report2Controller::class, 'consultations'])->name('TotalConsultations');

// route to display total consultations report
Route::get('report/TotalConsultReport', [Report2Controller::class, 'consultationsReport'])->name('TotalConsultReport');

// route to search branch gross profit
Route::get('report/BranchGrossProfit', [ReportController::class, 'branchGrossProfit'])->name('BranchGrossProfit');

// route to display branch gross profit report
Route::get('report/BranchGrossReport', [ReportController::class, 'branchGrossReport'])->name('BranchGrossReport');

// route to search top client by sales report
Route::get('report/TopClient', [Report2Controller::class, 'topClient'])->name('TopClient');

// route to display top client by sales report
Route::get('report/TopClientReport', [Report2Controller::class, 'topClientReport'])->name('TopClientReport');

// route to search transaction timeline
Route::get('report/TransactionTimeline', [ReportController::class, 'transactionTimeline'])->name('TransactionTimeline');

// route to display top client by sales report
Route::get('report/TransactionTimelineReport', [ReportController::class, 'timelineReport'])->name('TransactionTimelineReport');

// route to search stock taking
Route::get('report/StockTaking', [Report2Controller::class, 'stockTaking'])->name('StockTaking');

// route to display stock taking worksheets
Route::get('report/StockTakingReport', [Report2Controller::class, 'stockTakingReport'])->name('StockTakingReport');

// route to list not barcoded codes
Route::get('report/NotBarcodedCodes', [ReportController::class, 'notBarcodedReport'])->name('NotBarcodedCodes');

// route to search patients without microchip using patient type
Route::get('report/PatientsWithoutChip', [Report2Controller::class, 'patientsWithoutMicrochip'])->name('PatientsWithoutChip');

// route to list patients without microchip
Route::get('report/PatientsWithoutChipReport', [Report2Controller::class, 'patientsWithoutChipReport'])
    ->name('PatientsWithoutChipReport');

// route to search stock transaction
Route::get('report/StockTransaction', [Report2Controller::class, 'stockTransaction'])->name('StockTransaction');

// get the sub transactions for the selected transaction type
Route::get('ajax-tran-sub/{id}', [Report2Controller::class, 'ajaxTrans']);

// route to list stock transaction
Route::get('report/StockTransactionReport', [Report2Controller::class, 'stockTransactionReport'])
    ->name('StockTransactionReport');

// route to list total outstanding debts
Route::get('report/TotalOutstandingDebt', [ReportController::class, 'outstandingDebt'])->name('TotalOutstandingDebt');

// route to search patients species/weight
Route::get('report/PatientSpecies', [ReportController::class, 'patientSpecies'])->name('PatientSpecies');

// route to list patients without microchip
Route::get('report/PatientSpeciesReport', [ReportController::class, 'patientSpeciesReport'])->name('PatientSpeciesReport');
