@extends('layout.app')
@section('title') Dashboard @endsection
@section('css')
<!-- DataTables -->
<link href="{{ URL::asset('/assets/libs/jquery-vectormap/jquery-vectormap.min.css')}}" rel="stylesheet"
    type="text/css" />
<!-- Responsive datatable examples -->
<link href="{{ URL::asset('/assets/libs/datatables/datatables.min.css')}}" rel="stylesheet" type="text/css" />
<link href="https://cdn.jsdelivr.net/npm/remixicon@2.5.0/fonts/remixicon.css" rel="stylesheet">
<link href="https://code.iconify.design/1/1.0.7/iconify.min.js" rel="stylesheet">

<!-- app/views/user/login.blade.php -->
@section('content')

<div class="home-btn d-none d-sm-block">
    <a href="{{url('//www.bm.co.za')}}"><i class="mdi mdi-home-variant h2 text-white"></i></a>
</div>

<div>
    <div class="container-fluid p-0">
        <div class="row no-gutters">
            <div class="col-sm-4">
                <div class="authentication-page-content p-4 d-flex align-items-center min-vh-100">
                    <div class="w-100">
                        <div class="row justify-content-center">
                            <div class="col-lg-9">
                                <div>
                                    <div class="text-center">
                                        <h4 class="font-size-18 mt-4">Welcome Back !</h4>
                                        <p class="text-muted">Sign in to continue to Vetsoft Reports</p>
                                    </div>
                                    @if ( session()->has('success') )
                                    <div class="alert alert-success alert-dismissable" role="alert">
                                        {{ session()->get('success') }} <button type="button" class="close"
                                            data-dismiss="alert" aria-label="close">&times;</button></div>
                                    @elseif ( session()->has('warning') )
                                    <div class="alert alert-warning alert-dismissable">{{ session()->get('warning') }}
                                    </div>
                                    @elseif ( session()->has('info') )
                                    <div class="alert alert-info alert-dismissable">{{ session()->get('info') }}</div>
                                    @elseif ( session()->has('danger') )
                                    <div class="alert alert-danger alert-dismissable">{{ session()->get('danger') }}
                                    </div>
                                    @endif
                                    @yield('login')
                                    <div class="p-2 mt-2">
                                        {!! Form::open(array('url' => 'login')) !!}
                                        <form method="POST" action="{{ route('login') }}">
                                            @csrf
                                            {{-- modified --}}

                                            <div class="form-group auth-form-group-custom mb-4">
                                                <i class="ri-admin-line auti-custom-input-icon"></i>
                                                <label for="email">{{ __('Email Address') }}</label>
                                                <input id="email" type="email"
                                                    class="form-control @error('email') is-invalid @enderror"
                                                    name="email" value="{{ old('email') }}" required
                                                    autocomplete="email" placeholder="Enter Email">
                                                @error('email')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>

                                            {{-- original --}}

                                            <div class="form-group auth-form-group-custom mb-4">
                                                <i class="ri-lock-2-line auti-custom-input-icon"></i>
                                                <label for="password">{{ __('Password') }}</label>
                                                <input type="password"
                                                    class="form-control @error('password') is-invalid @enderror"
                                                    name="password" required autocomplete="current-password"
                                                    id="password" placeholder="Enter password">
                                                @error('password')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>

                                            <div class="form-group auth-form-group-custom mb-4">
                                                <i class="ri-secure-payment-fill auti-custom-input-icon"></i>
                                                <label for="enterprise_id">{{ __('EID') }}</label>
                                                <input type="text"
                                                    class="form-control @error('enterprise_id') is-invalid @enderror"
                                                    name="enterprise_id" required autocomplete="Enterprise-id"
                                                    id="enterprise_id" placeholder="Enter Enterprise ID">
                                                @error('password')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>


                                            <div class="mt-4 text-center">
                                                <button class="btn btn-primary w-md waves-effect waves-light"
                                                    type="submit">{{ __('Log In') }}</button>
                                            </div>

                                            <div class="mt-4 text-center">
                                                @if (Route::has('password.request'))
                                                <a href="{{ route('password.request') }}" class="text-muted"><i
                                                        class="mdi mdi-lock mr-1"></i>
                                                    {{ __('Forgot your password?') }}</a>
                                                @endif
                                            </div>
                                        </form>
                                        {!! Form::close() !!}
                                    </div>

                                    <div class="text-center">

                                        <div class="col-md-12 text-center">
                                            <p class="p_contact_no "><i class="mdi mdi-phone mr-1"></i>Contact no.
                                                021
                                                704 2720</p>

                                            {{-- <p style="width:100%;text-align: center;"><a id="tands"
                                                    href="{!!URL::route('users')!!}" style="font-size:9px">USERS</a>
                                                |
                                                <a id="tands" href="{!!URL::route('eids')!!}"
                                                    style="font-size:9px">EIDS</a>
                                            </p> --}}
                                        </div>

                                        <script>
                                            document.write(new Date().getFullYear())
                                        </script>© Vetsoft. <i class="mdi mdi-heart text-danger"></i>
                                        </p>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-8">
                {{-- <div class="authentication-bg"> --}}
                <div class="vetsoft-bg">
                    {{-- <div class="bg-overlay"></div> --}}
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
