<!-- app/views/reports/VATReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
<!-- DataTables -->
<link href="{{ URL::asset('/assets/libs/datatables/datatables.min.css')}}" rel="stylesheet" type="text/css" />
@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') V.A.T. Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('VAT')!!}">BACK</a> @endslot
    @endcomponent
    <!-- List VAT Summary Report Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">
                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Branch : <strong>{{ $branch_name }}</strong></h6>
                        <h6>Print Date: <strong> {{ $date->format('d/m/Y') }} {{ $date->format('H:m') }}</strong></h6>
                        <h6 class="mb-3">Reporting Period - Start
                            Date:<strong>{{ $start_date->format('d/m/Y') }}</strong> End Date:
                            <strong>{{ $end_date->format('d/m/Y') }}</strong>
                        </h6>
                    </div>

                    <table class="table table-striped" id="dataTable">
                        @if (count($vatRepArray) > 0)
                        <!-- Table Body -->
                        <tbody>
                            @foreach ($vatRepArray as $vat)
                            @if($vat->adjBatch != null)
                            <tr>
                                <!-- Adjustment Batch -->
                                <td align="right">{{ $vat->adjBatch }}</td>
                                <td align="right">{{ $vat->vatAsd }}</td>
                                <td align="right">To : </td>
                                <td align="right">{{ $vat->vatAed }}</td>
                            </tr>
                            @endif
                            @if($vat->receiptBatch != null)
                            <tr>
                                <!-- Receipt Batch -->
                                <td align="right">{{ $vat->receiptBatch }}</td>
                                <td align="right">{{ $vat->vatRsd }}</td>
                                <td align="right">To : </td>
                                <td align="right">{{ $vat->vatRed }}</td>
                            </tr>
                            @endif
                            @if($vat->invoiceBatch != null)
                            <tr>
                                <!-- Invoice Batch -->
                                <td align="right">{{ $vat->invoiceBatch }}</td>
                                <td align="right">{{ $vat->vatIsd }}</td>
                                <td align="right">To : </td>
                                <td align="right">{{ $vat->vatIed }}</td>
                            </tr>
                            @endif
                            @if($vat->interestBatch != null)
                            <tr>
                                <!-- Interest Batch -->
                                <td align="right">{{ $vat->interestBatch }}</td>
                                <td align="right">{{ $vat->vatInsd }}</td>
                                <td align="right">To : </td>
                                <td align="right">{{ $vat->vatIned }}</td>
                            </tr>
                            @endif
                            <tr>
                                <td>INVOICE SUMMARY</td>
                            </tr>
                            <tr>
                                <!-- Accommodation -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->accom }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{number_format($vat->accom_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->accom_perc, 2) }}</div>
                                </td>
                            <tr>
                            <tr>
                                <!-- Dispensing -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->disp }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->disp_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->disp_perc, 2) }}</div>
                                </td>
                            <tr>
                            <tr>
                                <!-- Travelling -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->trav }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->trav_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->trav_perc, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Medication -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->med }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->med_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->med_perc, 2) }}</div>
                                </td>
                            <tr>
                            <tr>
                                <!-- Consultations Fees -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->cons }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->cons_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->cons_perc, 2) }}</div>
                                </td>
                            <tr>
                            <tr>
                                <!-- Lab Work -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->lab }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->lab_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->lab_perc, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- X-Rays -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->xray }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->xray_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->xray_perc, 2) }}</div>
                                </td>
                            <tr>
                            <tr>
                                <!-- Injections -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->inj }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->inj_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->inj_perc, 2) }}</div>
                                </td>
                            <tr>
                            <tr>
                                <!-- Procedures -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->proc }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->proc_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->proc_perc, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Surcharges -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->surg }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->surg_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->surg_perc, 2) }}</div>
                                </td>
                            <tr>
                            <tr>
                                <!-- Vaccinations -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->vacc }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->vacc_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right" align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->vacc_perc, 2) }}</div>
                                </td>
                            <tr>
                            <tr>
                                <!-- Hospital Stock -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->hosp }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->hosp_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->hosp_perc, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Merchandise -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->merch }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->merch_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->merch_perc, 2) }}</div>
                                </td>
                            <tr>
                            <tr>
                                <!-- Food -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->food }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->food_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->food_perc, 2) }}</div>
                                </td>
                            <tr>
                            <tr>
                                <!-- Dentistry -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->dent }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->dent_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->dent_perc, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Grooming -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->grom }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->grom_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->grom_perc, 2) }}</div>
                                </td>
                            <tr>
                            <tr>
                                <!-- General Services -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->gen }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->gen_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->gen_perc, 2) }}</div>
                                </td>
                            <tr>
                            <tr>
                                <!-- Invoice Discount -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->inv_disc }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->inv_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->inv_perc, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Unknown -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->unknown }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->unknown_amt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">Percent of Total : </div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->unknown_perc, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Total Invoiced -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->totInvoiced }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->totInvAmt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">(Includes VAT and all discounts)</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Base Invoice Amount -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->baseInvoice }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->baseInvAmt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">(Excludes VAT and line item discount)</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Less Other Invoice Discount -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->lessDisc }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->lessDiscAmt, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Sub Total -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->subTot }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->subTotal, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Add VAT on Invoices -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->addVAT }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->addVATInv, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Control Total -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->contrTot }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->contrTotal, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Adjustments -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->adjust }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->adjustment, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Adjustments V.A.T. -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->adjustVAT }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->adjustmentVAT, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Invoice Total -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->invoiceTot }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->invoiceTotal, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Zero Rating Amount -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->zeroRating }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->zeroRatingAmt, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">(Items excluded from VAT)</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Zero Rating Discount -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->zeroDiscount }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->zeroRatingDiscount, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Zero Rating Total -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->zeroTotal }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->zeroRatingTotal, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Exempt Amount -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->exempt }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->exemptAmount, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">(Clients excluded from VAT)</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Exempt Amount Discount -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->exemptDiscount }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->exemptAmtDiscount, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Exempt Amount Total -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->exemptTotal }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->exemptAmtTotal, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- RECEIPT SUMMARY -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->receiptSummary }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Total Receipts -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->receipts }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->totalReceipts, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">(Includes VAT)</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Less Receipt Discount -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->lessDiscount }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->lessReceiptDisc, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Sub Total -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->sub }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->subTotal2, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Less VAT Recovered -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->lessVAT }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->lessVATRecover, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Actual Receipts -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->actual }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->actualReceipts, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Adjustment Summary -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->adjustSummary }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Adjustments -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->adjustments }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->adjustSum, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">(Excludes VAT)</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- VAT Adjustments -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->VATAdjustments }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->VATAdjust, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Total Adjustments -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->totAdjust }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->totalAdjustments, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Interest Summary -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->interestSummary }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Interest Charged -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->interest }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->interestCharged, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">(No VAT Charged on Interest)</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Accounting Fee -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->accounting }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->accountingFee, 2) }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">(Excludes VAT)</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- VAT on Accounting Fee -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->VATAccounting }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->VATAccountingFee, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Total Charges -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->totCharges }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->totalCharges, 2) }}</div>
                                </td>
                            </tr>
                            <tr>
                                <!-- Net Debtors Change -->
                                <td class="table-text">
                                    <div align="right">{{ $vat->netDebtors }}</div>
                                </td>
                                <td class="table-text">
                                    <div align="right">{{ number_format($vat->netDebtorsChange, 2) }}</div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        @else
                        <div class="alert alert-info" role="alert">No VAT Report to display</div>
                        @endif
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready( function () {
    var table = $('#table_id').DataTable({
        columnsDefs: [{
            type: 'html-num', targets: '_all'
        }]
    });
} );
    </script>

    @endsection

    @push('plugin-scripts')
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/fixedcolumns/3.3.2/js/dataTables.fixedColumns.min.js"></script>
    @endpush

    @push('custom-scripts')
    <script src="{{ asset('assets/js/data-table.js') }}"></script>
    @endpush
