<!-- app/views/reports/UserTravelPerType.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') User Travel Detail Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="UserTravel">BACK</a> @endslot
    @endcomponent
    <!-- Create User Travel Search Form... -->
    <div class="row">
        <div class="col-xl-6 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">

                    {!! HTML::ul($errors->all()) !!}
                    {!! Form::open(array('route' => 'UserTravelReport2', 'method'=>'GET','files'=>true)) !!}

                    <div class="col-sm-8 col-md-8">
                        <div class="form-group">
                            {!! Form::Label('user_type', 'User Type') !!}
                            <select class="form-control input-sm form-control-sm" required name="user_type"
                                id="user_type">
                                <option disabled selected hidden>Select User Type</option>
                                @foreach($userTypes as $type)
                                <option value="{{$type->id}}" @if(old('user_type')==$type->id)
                                    selected="selected"@endif>{{$type->type}} {{$type->description}}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            {!! Form::label('start_date', 'Start Date') !!}
                            {!! Form::date('start_date', Request::old('start_date'), array('class' => 'form-control
                            input-sm form-control-sm', 'id'=>'start_date')) !!}
                        </div>

                        <div class="form-group">
                            {!! Form::label('end_date', 'End Date') !!}
                            {!! Form::date('end_date', Request::old('end_date'), array('class' => 'form-control
                            form-control-sm', 'id'=>'end_date')) !!}
                        </div>

                    </div>

                    <div class="col-xs-12 col-sm-12 col-md-12">
                        {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>

    </div>

    @endsection
