<!-- app/views/reports/StockValuationReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Stock Valuation Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('StockValuation')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Stock Valuation Report Form... -->
    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Warehouse: <strong>{{ $warehouse }}</strong></h6>
                        <h6>Printed Date: <strong>{{ $date->format('d/m/Y') }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @if (count($stockArray) > 0)
                                @foreach($typeArray as $type)
                                    <!-- Table Headings -->
                                    <thead>
                                        <th><strong>Stock Type: {{ $type->description }}</strong></th>
                                    </thead>
                                    <thead>
                                        <th>WHS</th>
                                        <th>Description</th>
                                        <th>UOM</th>
                                        <th>QTY OH</th>
                                        <th>Cost Price</th>
                                        <th>Sales Price</th>
                                    </thead>

                                    @foreach ($stockArray as $stock)
                                        @if($type->description != $stock->typeDesc)
                                            @continue
                                        @endif

                                        <!-- Table Body -->
                                        <tbody>
                                            <tr>
                                                <!-- Warehouse -->
                                                <td class="table-text">
                                                    <div>{{ $stock->warehouse }}</div>
                                                </td>

                                                <!-- Description -->
                                                <td class="table-text">
                                                    <div>{{ $stock->description }}</div>
                                                </td>

                                                <!-- UOM -->
                                                <td class="table-text">
                                                    <div>{{ $stock->uom }}</div>
                                                </td>

                                                <!-- Quantity on hand -->
                                                <td class="table-text">
                                                    <div>{{ number_format($stock->qty_oh, 2) }}</div>
                                                </td>

                                                <!-- Cost Price -->
                                                <td class="table-text">
                                                    <div>{{ number_format($stock->cost_price, 2) }}</div>
                                                </td>

                                                <!-- Sales Price -->
                                                <td class="table-text">
                                                    <div>{{ number_format($stock->sales_price, 2) }}</div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        <tfoot></tfoot>
                                        <tfoot>
                                            <th>Sub Total</th>
                                            <th></th>
                                            <th></th>
                                            <th></th>
                                            <th>{{ number_format($type->cost_price, 2) }}</th>
                                            <th>{{ number_format($type->sales_price, 2) }}</th>
                                        </tfoot>
                                        @foreach($warehsTots as $warehs)
                                            @if($warehs->type_id == $type->type_id)
                                                <tr>
                                                    <td>
                                                        <div>Warehouse:{{ $warehs->name }}</div>
                                                    </td>
                                                    <td>
                                                        <div></div>
                                                    </td>
                                                    <td>
                                                        <div></div>
                                                    </td>
                                                    <td>
                                                        <div></div>
                                                    </td>
                                                    <td>
                                                        <div>{{ number_format($warehs->cost_price, 2) }}</div>
                                                    </td>
                                                    <td>
                                                        <div>{{ number_format($warehs->sales_price, 2) }}</div>
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach
                                        <tr>
                                            <td class="table-text">
                                                <div>-------------------------------------------------</div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    <tfoot>
                                        <th>Grand Total</th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th>{{ number_format($grand_cost, 2) }}</th>
                                        <th>{{ number_format($grand_sales, 2) }}</th>
                                    </tfoot>
                                    @foreach($warehouseTots as $warehs)
                                        <tr>
                                            <td>
                                                <div>Warehouse: {{ $warehs->name }}</div>
                                            </td>
                                            <td>
                                                <div></div>
                                            </td>
                                            <td>
                                                <div></div>
                                            </td>
                                            <td>
                                                <div></div>
                                            </td>
                                            <td>
                                                <div>{{ number_format($warehs->cost_price, 2) }}</div>
                                            </td>
                                            <td>
                                                <div>{{ number_format($warehs->sales_price, 2) }}</div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>

$(document).ready(function() {

$('#datatable').DataTable( {

    "initComplete": function (settings, json) {
$("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
},

    paging: true,
    responsive: false,
    columnDefs: [ {
        targets: [ 0 ],
        orderData: [ 0, 1 ]
    }, {
        targets: [ 1 ],
        orderData: [ 1, 0 ]
    }, {
        targets: [ 4 ],
        orderData: [ 4, 0 ]
    } ],

    dom: 'lBfrtip',
    buttons: [
        'copy',
        {
            extend: 'excel',
            messageTop: 'reportHeader',
            title: null,
        },
        {
            extend: 'pdfHtml5',
            messageBottom: null,
            messageTop: title,
            title: "Debtors Age Analysis Report",
            orientation: 'landscape',
            pageSize: 'LEGAL'
        },

    ]

} );
} );

    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    @endsection

    @endpush
