<!-- app/views/reports/StockValuation.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Stock Valuation Report @endslot
@slot('li_1') @endslot
@endcomponent
<!-- Create Stock Valuation Search Form... -->

<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">

                {!! HTML::ul($errors->all()) !!}
                {!! Form::open(array('route' => 'StockValuationReport', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">
                    <div class="form-group">
                        {!! Form::Label('warehouse_id', 'Warehouse') !!}
                        <select class="form-control input-sm form-control-sm" name="warehouse_id" id="warehouse_id">
                            <option value="">All Warehouses</option>
                            @foreach($warehouses as $warehouse)
                            <option value="{{$warehouse->id}}" @if(old('warehouse_id')==$warehouse->id)
                                selected="selected"@endif>{{$warehouse->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="stock_type" name="stock_type">
                        <label for="stock_type"> Report on All Stock Types</label><br>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('type_id', 'Stock Type') !!}
                        <select class="form-control input-sm form-control-sm" name="type_id" id="type_id">
                            <option value="">All Stock Types</option>
                            @foreach($types as $type)
                            <option value="{{$type->id}}" @if(old('type_id')==$type->id)
                                selected="selected"@endif>{{$type->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="negative_stock" name="negative_stock">
                        <label for="negative_stock"> Include Negative Stock</label><br>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="change_amt" name="change_amt">
                        <label for="change_amt"> Change Negative Stock Amount</label><br>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="detail_report" name="detail_report">
                        <label for="detail_report"> Show Stock Item Detail</label><br>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('supplier_id', 'Supplier') !!}
                        <select class="form-control input-sm form-control-sm" required name="supplier_id"
                            id="supplier_id">
                            <option disabled selected hidden>No Supplier</option>
                            @foreach($suppliers as $supplier)
                            <option value="{{$supplier->id}}" @if(old('supplier_id')==$supplier->id)
                                selected="selected"@endif>{{$supplier->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('manufacturer', 'Manufacturer') !!}
                        <select class="form-control input-sm form-control-sm" required name="manufacturer"
                            id="manufacturer">
                            <option disabled selected hidden>No Manufacturer</option>
                            @foreach($suppliers as $supplier)
                            <option value="{{$supplier->id}}" @if(old('manufacturer')==$supplier->id)
                                selected="selected"@endif>{{$supplier->name}}</option>
                            @endforeach
                        </select>
                    </div>

                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>

@endsection
