<!-- app/views/reports/StockTransactions.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Stock Transaction Report @endslot
@slot('li_1') @endslot
@endcomponent
<!-- Create Stock Transactions Search Form... -->

<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">

                {!! HTML::ul($errors->all()) !!}
                {!! Form::open(array('route' => 'StockTransactionReport', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">

                    <div class="form-group">
                        {!! Form::Label('tran_type', 'Transaction Type') !!}
                        <select class="form-control input-sm form-control-sm" name="tran_type" required id="tran_type">
                            <option value="">Select Transaction</option>
                            @foreach($trans as $tran)
                            <option value="{{$tran->id}}" @if(old('tran_type')==$tran->id)
                                selected="selected"@endif>{{$tran->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('sub_tran', 'Sub Transaction Type') !!}
                        <select class="form-control input-sm form-control-sm" name="sub_tran" id="sub_tran">
                            <option value="{{ old('sub_tran') }}">Select Transaction Type First</option>
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('start_date', 'Start Date') !!}
                        {!! Form::date('start_date', Request::old('start_date'), array('class' => 'form-control input-sm
                        form-control-sm', 'required', 'id'=>'start_date')) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::label('end_date', 'End Date') !!}
                        {!! Form::date('end_date', Request::old('end_date'), array('class' => 'form-control input-sm
                        form-control-sm', 'required', 'id'=>'end_date')) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::Label('warehouse_id', 'Warehouse') !!}
                        <select class="form-control input-sm form-control-sm" name="warehouse_id" id="warehouse_id">
                            <option value="">All Warehouses</option>
                            @foreach($warehouses as $warehouse)
                            <option value="{{$warehouse->id}}" @if(old('warehouse_id')==$warehouse->id)
                                selected="selected"@endif>{{$warehouse->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('type_id', 'Stock Type') !!}
                        <select class="form-control input-sm form-control-sm" required name="type_id" id="type_id">
                            <option disabled selected hidden>All Types</option>
                            @foreach($types as $type)
                            <option value="{{$type->id}}" @if(old('type_id')==$type->id)
                                selected="selected"@endif>{{$type->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('code_id', 'Stock Code') !!}
                        <select class="form-control input-sm form-control-sm" name="code_id" id="code_id">
                            <option value="{{ old('code_id') }}">Select Type First</option>
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('supplier_id', 'Supplier') !!}
                        <select class="form-control input-sm form-control-sm" required name="supplier_id"
                            id="supplier_id">
                            <option disabled selected hidden>All Suppliers</option>
                            @foreach($suppliers as $supplier)
                            <option value="{{$supplier->id}}" @if(old('supplier_id')==$supplier->id)
                                selected="selected"@endif>{{$supplier->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('manufacturer', 'Manufacturer') !!}
                        <select class="form-control input-sm form-control-sm" required name="manufacturer"
                            id="manufacturer">
                            <option disabled selected hidden>All Manufacturers</option>
                            @foreach($suppliers as $supplier)
                            <option value="{{$supplier->id}}" @if(old('supplier_id')==$supplier->id)
                                selected="selected"@endif>{{$supplier->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('branch_id', 'Branch') !!}
                        <select class="form-control input-sm form-control-sm" name="branch_id" id="branch_id">
                            <option value="">All Branches</option>
                            @foreach($branches as $branch)
                            <option value="{{$branch->id}}" @if(old('branch_id')==$branch->id)
                                selected="selected"@endif>{{$branch->description}}</option>
                            @endforeach
                        </select>
                    </div>

                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>

</div>

@endsection
