<!-- app/views/reports/StockTakingReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Stock Taking Worksheets @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('StockTaking')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Stock Taking Report Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>For Warehouse: <strong>{{ $warehouse->name }}</strong></h6>
                        <h6>Stock Type: <strong>{{ $type->description }}</strong></h6>
                        <h6>Printed on: <strong>{{ $date->format('d/m/Y') }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            <!-- Table Headings -->
                            <thead>
                                <th>Description</th>
                                <th>UOM</th>
                                <th>Comp. QTY</th>
                                <th>Counted QTY</th>
                                <th>Adjustment QTY</th>
                                @if($include_prices == 'Yes')
                                    <th>Cost Price</th>
                                @endif
                            </thead>

                            <!-- Table Body -->
                            <tbody>
                                @foreach ($stockTaking as $item)
                                    <tr>
                                        <! -- Description -->
                                        <td class="table-text">
                                            <div>{{ $item->description }}</div>
                                        </td>

                                        <! -- UOM -->
                                        <td class="table-text">
                                            <div>{{ $item->uom }}</div>
                                        </td>

                                        <! -- Comp QTY -->
                                        <td class="table-text">
                                            <div>{{ $item->comp_qty }}</div>
                                        </td>

                                        <! -- Counted QTY -->
                                        <td class="table-text">
                                            <div>{{ $item->counted_qty }}</div>
                                        </td>

                                        <! -- Adjustment QTY -->
                                        <td class="table-text">
                                            <div>{{ $item->adjustment_qty }}</div>
                                        </td>

                                        <! -- Cost Price -->
                                        @if($include_prices == 'Yes')
                                            <td class="table-text">
                                                <div>{{ $item->price }}</div>
                                            </td>
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')
