<!-- app/views/reports/SalesReportByAll.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') STOCK SALES (By System Type) REPORT @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('SalesByType')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- List Stock Sales Report Form... -->
    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">
                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>For Date Range:<strong>{{ $start_date }}</strong> To: <strong>{{ $end_date }}</strong></h6>
                        <h6>For Branches: <strong> {{ $branch }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped display" id="datatable" style="width:100%">
                            @if (count($sales) > 0)
                            @foreach($typeTot as $type)
                            <!-- Table Headings -->
                            <thead>
                                <th>STOCK TYPE: <strong>{{ $type->description }}</strong></th>
                            </thead>
                            <thead>
                                <th>Item</th>
                                <th>Qty</th>
                                <th>Mass</th>
                                <th>Cost</th>
                                <th>Sales</th>
                                <th>Discount</th>
                                <th>Profit</th>
                            </thead>

                            @foreach ($sales as $sale)
                            @if($sale->type_id != $type->id)
                            @continue
                            @endif

                            <!-- Table Body -->
                            <tbody>
                                <tr>
                                    <!-- Stock Type -->
                                    <td class="table-text">
                                        <div>{{ $sale->ref }}</div>
                                    </td>
                                    <!-- Quantity -->
                                    <td class="table-text">
                                        <div>{{ number_format($sale->qty, 2) }}</div>
                                    </td>
                                    <!-- Mass -->
                                    <td class="table-text">
                                        <div>{{ number_format($sale->mass, 2) }}</div>
                                    </td>
                                    <!-- Cost -->
                                    <td class="table-text">
                                        <div>{{ number_format($sale->cost, 2) }}</div>
                                    </td>
                                    <!-- Sales -->
                                    <td class="table-text">
                                        <div>{{ number_format($sale->sales, 2) }}</div>
                                    </td>
                                    <!-- Discount -->
                                    <td class="table-text">
                                        <div>{{ number_format($sale->discount, 2) }}</div>
                                    </td>
                                    <!-- Profit -->
                                    <td class="table-text">
                                        <div>{{ number_format($sale->profit, 2) }}</div>
                                    </td>
                                </tr>
                            </tbody>
                            @endforeach
                            <tfoot></tfoot>
                            <tfoot>
                                <tr>
                                    <th></th>
                                    <th>QTY</th>
                                    <th>Mass</th>
                                    <th>Cost</th>
                                    <th>Sales</th>
                                    <th>Discount</th>
                                    <th>Profit</th>
                                </tr>
                            </tfoot>
                            <tfoot>
                                <tr>
                                    <th><strong>Sub Total</strong></th>
                                    <th>{{ number_format($type->qty, 2) }}</th>
                                    <th>{{ number_format($type->mass, 2) }}</th>
                                    <th>{{ number_format($type->cost, 2) }}</th>
                                    <th>{{ number_format($type->sales, 2) }}</th>
                                    <th>{{ number_format($type->discount, 2) }}</th>
                                    <th>{{ number_format($type->profit, 2) }}</th>
                                </tr>
                            </tfoot>
                            @endforeach
                            <tfoot>
                                <tr>
                                    <th><strong>Grand Total</strong></th>
                                    <th>{{ number_format($qty_tot, 2) }}</th>
                                    <th>{{ number_format($mass_tot, 2) }}</th>
                                    <th>{{ number_format($cost_tot, 2) }}</th>
                                    <th>{{ number_format($sales_tot, 2) }}</th>
                                    <th>{{ number_format($discount_tot, 2) }}</th>
                                    <th>{{ number_format($profit_tot, 2) }}</th>
                                </tr>
                            </tfoot>
                            @else
                            <div class="alert alert-info" role="alert">No Sales are available</div>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        var title = $('#reportHeader').html();

    title = "For Date Range: " +'{!! $start_date !!}' +" To: " +'{!! $end_date !!}'
            +"\n" +"For Branches: "+'{!! $branch !!}';

    $(document).ready(function() {
        var printCounter = 0;
        $('#datatable').DataTable( {

            columnDefs: [ {
                targets: [ 0 ],
                orderData: [ 0, 1 ]
            }, {
                targets: [ 1 ],
                orderData: [ 1, 0 ]
            }, {
                targets: [ 4 ],
                orderData: [ 4, 0 ]
            } ],
            dom: 'lBfrtip',
            buttons: [
                'copy',
                {
                    extend: 'excel',
                    messageTop: title,
                    title: null,
                },
                {
                    extend: 'pdfHtml5',
                    messageBottom: null,
                    messageTop: title,
                    title: "STOCK SALES (By System Type) REPORT",
                }
            ]
        } );
    } );
    </script>



    @section('script')
    <!-- Required datatable js -->
    <!-- <script src="//cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    </script> remove this b/c giving { error-->

    <!--<script src="//code.jquery.com/jquery-3.5.1.js"></script>  remove this b/c breaking menu -->
    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.print.min.js"></script>

    @endsection

    @endpush
