<!-- app/views/reports/ReprintTill.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Reprint Till Ledger @endslot
@slot('li_1') @endslot
@endcomponent
<!-- Create Reprint Till LedgerSearch Form... -->

<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">

                {!! HTML::ul($errors->all()) !!}

                {!! Form::open(array('route' => 'ReprintTillLedger', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">
                    <div class="form-group">
                        {!! Form::Label('user_code', 'Operator') !!}
                        <select class="form-control input-sm form-control-sm" name="user_code" required id="user_code">
                            <option value="">Select Operator</option>
                            @foreach($reps as $rep)
                            <option value="{{$rep->user_code}}" @if(old('user_code')==$rep->user_code)
                                selected="selected"@endif>{{$rep->user_code}} {{$rep->user_name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('till_no', 'Ledger Number') !!}
                        <select class="form-control input-sm form-control-sm" name="till_no" id="till_no">
                            <option value="">Select Till No</option>
                            @foreach($tills as $till)
                            <option value="{{$till->number}}" @if(old('till_no')==$till->number)
                                selected="selected"@endif>{{$till->number}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('start_date', 'Start Date') !!}
                        {!! Form::date('start_date', Request::old('start_date'), array('class' => 'form-control
                        input-sm
                        form-control-sm', 'id'=>'start_date')) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::label('end_date', 'End Date') !!}
                        {!! Form::date('end_date', Request::old('end_date'), array('class' => 'form-control
                        form-control-sm', 'id'=>'end_date')) !!}
                    </div>

                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>

</div>

@endsection
