<!-- app/views/reports/PatientWithoutChip.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Patients Without Microchip Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a
        href="{!!URL::route('PatientsWithoutChip')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Patient Without Chip Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Branch: <strong>{{ $branch->description }}</strong></h6>
                        <h6>Patient Type: <strong>{{ $patType->description }}</strong> and
                            <strong>{{ $status }}</strong></h6>
                        <h6>Printed Date: <strong>{{ $date->format('d/m/Y') }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            <!-- Table Headings -->
                            <thead>
                                <th>Patient</th>
                                <th>Name</th>
                                <th>Customer</th>
                                <th>Surname</th>
                            </thead>

                            <!-- Table Body -->
                            <tbody>

                                @foreach($patientWithoutChip as $item)
                                    <tr>
                                        <! -- Patient -->
                                        <td class="table-text">
                                            <div>{{ $item->patient }}</div>
                                        </td>

                                        <! -- Name -->
                                        <td class="table-text">
                                            <div>{{ $item->patientName }}</div>
                                        </td>

                                        <! -- Customer -->
                                        <td class="table-text">
                                            <div>{{ $item->customer }}</div>
                                        </td>

                                        <! -- Name -->
                                        <td class="table-text">
                                            <div>{{ $item->surname }}</div>
                                        </td>
                                    </tr>
                                @endforeach
                                <tfoot></tfoot>
                                <tfoot>
                                    <th>Total</th>
                                    <th>Patients</th>
                                    <th>{{ number_format($patientCnt) }}</th>
                                </tfoot>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        $(document).ready(function() {

    $('#datatable').DataTable( {

        "initComplete": function (settings, json) {
    $("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
  },

        paging: true,
        responsive: false,
        columnDefs: [ {
            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],

        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: null,
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: 'title',
                title: "Debtors Age Analysis Report",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ]

    } );
} );

    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    @endsection

    @endpush
