<!-- app/views/reports/PatientSpeciesReport2.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Patient Species/Weight Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('PatientSpecies')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Patient Species/Weight  Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">

                        <h6>Printed Date: <strong>{{ $date->format('d/m/Y') }}</strong></h6>
                        <h6>Species: <strong>{{ $species->type }}</strong> Sex: <strong>{{ $gender }}</strong></h6>
                        <h6>Start Age: <strong>{{ $min_age }}</strong> End Age: <strong>{{  $max_age }}</strong></h6>
                        <h6>Start Weight: <strong>{{ $min_weight }}</strong> End Weight:
                            <strong>{{ $max_weight }}</strong></h6>
                        <h6>Printed Only Active Patients: <strong>{{ $patient_status }}</strong> Printed Only Active
                            Clients: <strong>{{ $client_status }}</strong></h6>
                        <h6>Printed Only Patients Seen Since: <strong>{{ $last_seen }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped display nowrap" id="datatable" style="width:100%">
                            @if(count($patientArray) > 0)
                            <!-- Table Header -->
                            <thead>
                                <th>Patient No</th>
                                <th>Patient Name</th>
                                <th>Breed</th>
                                <th>Sex</th>
                                <th>Age (Yrs)</th>
                                <th>Weight</th>
                                <th>Active</th>
                                <th>Client</th>
                                <th>Client Name</th>
                                <th>Address Line 1</th>
                                <th>Address Line 2</th>
                                <th>Address Line 3</th>
                                <th>Post Code</th>
                                <th>Telephone No</th>
                                <th>Mobile No</th>
                                <th>Email Address</th>
                                <th>Last Seen</th>
                            </thead>

                            <!-- Table Body -->
                            <tbody>
                                @foreach($patientArray as $patient)
                                <tr>
                                    <! -- Patient No -->
                                        <td class="table-text">
                                            <div>{{ $patient->patient }}</div>
                                        </td>

                                        <! -- Patient Name -->
                                            <td class="table-text">
                                                <div>{{ $patient->name }}</div>
                                            </td>

                                            <! -- Breed -->
                                                <td class="table-text">
                                                    <div>{{ $patient->breed }}</div>
                                                </td>

                                                <! -- Sex -->
                                                    <td class="table-text">
                                                        <div>{{ $patient->sex }}</div>
                                                    </td>

                                                    <! -- Age -->
                                                        <td class="table-text">
                                                            <div>{{ number_format($patient->age) }}</div>
                                                        </td>

                                                        <! -- Weight -->
                                                            <td class="table-text">
                                                                <div>{{ $patient->weight }}</div>
                                                            </td>

                                                            <! -- Status -->
                                                                <td class="table-text">
                                                                    <div>{{ $patient->active }}</div>
                                                                </td>

                                                                <! -- Customer No -->
                                                                    <td class="table-text">
                                                                        <div>{{ $patient->customer }}</div>
                                                                    </td>

                                                                    <! -- Client Name -->
                                                                        <td class="table-text">
                                                                            <div>{{ $patient->client }}</div>
                                                                        </td>

                                                                        <! -- Address 1 -->
                                                                            <td class="table-text">
                                                                                <div>{{ $patient->address1 }}</div>
                                                                            </td>

                                                                            <! -- Address 2 -->
                                                                                <td class="table-text">
                                                                                    <div>{{ $patient->address2 }}</div>
                                                                                </td>

                                                                                <! -- Address 3 -->
                                                                                    <td class="table-text">
                                                                                        <div>{{ $patient->address3 }}
                                                                                        </div>
                                                                                    </td>

                                                                                    <! -- Post Code -->
                                                                                        <td class="table-text">
                                                                                            <div>
                                                                                                {{ $patient->post_code }}
                                                                                            </div>
                                                                                        </td>

                                                                                        <! -- Telephone No -->
                                                                                            <td class="table-text">
                                                                                                <div>
                                                                                                    {{ $patient->telNo }}
                                                                                                </div>
                                                                                            </td>

                                                                                            <! -- Mobile No -->
                                                                                                <td class="table-text">
                                                                                                    <div>
                                                                                                        {{ $patient->mobileNo }}
                                                                                                    </div>
                                                                                                </td>

                                                                                                <! -- Email Address -->
                                                                                                    <td
                                                                                                        class="table-text">
                                                                                                        <div>
                                                                                                            {{ $patient->email }}
                                                                                                        </div>
                                                                                                    </td>

                                                                                                    <! -- Date last seen
                                                                                                        -->
                                                                                                        <td
                                                                                                            class="table-text">
                                                                                                            <div>
                                                                                                                {{ $patient->last_seen }}
                                                                                                            </div>
                                                                                                        </td>
                                </tr>
                                @endforeach
                            </tbody>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endsection

    @push('plugin-scripts')

    <script>
        $('#datatable').DataTable( {



        paging: true,
        scrollX: true,


        responsive: false,
        fixedColumns: false,
        scrollCollapse: true,
         fixedColumns: true,

        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: 'null',
            },
            {
                extend: 'pdfHtml5',
                messageBottom: 'null',
                messageTop: "title",
                title: "PATIENT SPECIES/WEIGHT REPORT",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ],


    } );


    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>


    <link href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.0.0/css/bootstrap.css" rel="stylesheet"
        type="text/css" />
    <link href="https://nightly.datatables.net/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />

    {{-- <script src="https://nightly.datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="https://nightly.datatables.net/js/dataTables.bootstrap4.min.js"></script> --}}


    @endsection

    @endpush
