<!-- app/views/reports/PatientSpecies.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Patient Species/Weight Report @endslot
@slot('li_1') @endslot
@endcomponent
<!-- Create Patient Species Search Form... -->

<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">

                {!! HTML::ul($errors->all()) !!}
                {!! Form::open(array('route' => 'PatientSpeciesReport', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">

                    <div class="form-group">
                        {!! Form::Label('patType_id', 'Species') !!}
                        <select class="form-control input-sm form-control-sm" name="patType_id" required
                            id="patType_id">
                            <option value="">Select Species</option>
                            @foreach($types as $type)
                            <option value="{{$type->id}}" @if(old('patType_id')==$type->id)
                                selected="selected"@endif>{{$type->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('gender', 'Sex') !!}
                        {!! Form::select('gender', array('A'=>'All', 'M'=>'Male', 'F'=>'Female', 'S'=>'Spay',
                        'N'=>'Neutered'),
                        null, array('class' => 'form-control input-sm form-control-sm', 'required')) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::label('min_age', 'Min. Age (Yrs)') !!}
                        <input class="form-control input-sm form-control-sm" type="text" id="min_age" name="min_age"
                            value="0">
                    </div>

                    <div class="form-group">
                        {!! Form::label('max_age', 'Max. Age (Yrs)') !!}
                        <input class="form-control input-sm form-control-sm" type="text" id="max_age" name="max_age"
                            value="99">
                    </div>

                    <div class="form-group">
                        {!! Form::label('min_weight', 'Minimum Weight') !!}
                        <input class="form-control input-sm form-control-sm" type="text" id="min_weight"
                            name="min_weight" value="0.00">
                    </div>

                    <div class="form-group">
                        {!! Form::label('max_weight', 'Maximum Weight') !!}
                        <input class="form-control input-sm form-control-sm" type="text" id="max_weight"
                            name="max_weight" value="200.00">
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="active_patients" name="active_patients" checked>
                        <label for="active_patients"> Active Patients</label><br>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="active_clients" name="active_clients" checked>
                        <label for="active_clients"> Active Clients</label><br>
                    </div>

                    <div class="form-group">
                        {!! Form::label('last_seen', 'Date Last Seen') !!}
                        {!! Form::date('last_seen', Request::old('last_seen'), array('class' => 'form-control input-sm
                        form-control-sm', 'required', 'id'=>'last_seen')) !!}
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="print_details" name="print_details" checked>
                        <label for="print_details"> Print All Details</label><br>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('branch_id', 'Branch') !!}
                        <select class="form-control input-sm form-control-sm" name="branch_id" id="branch_id">
                            <option value="">All Branches</option>
                            @foreach($branches as $branch)
                            <option value="{{$branch->id}}" @if(old('branch_id')==$branch->id)
                                selected="selected"@endif>{{$branch->description}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>

@endsection
