<!-- app/views/reports/PatientFlagReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Patient Flag Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('PatientFlag')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Patient Flag Report Form... -->
    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6><strong>Patient Flag Report</strong></h6>
                        <h6>Search Flag Type: <strong>{{ $patientFlag }}</strong></h6>
                        <h6>Printed Date: <strong>{{ $date->format('d/m/Y') }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @if (count($patient_clientArray) > 0)
                            @foreach($branchArray as $branch)
                            <!-- Table Headings -->
                            <thead>
                                <th><strong>Branch: {{ $branch->branch_name }}</strong></th>
                            </thead>
                            <thead>
                                <th>Patient</th>
                                <th>Patient Name</th>
                                <th>Date of Birth</th>
                                <th>Breed</th>
                                <th>Takeon Date</th>
                                @if($patientFlag == 'Inactive Patients')
                                <th>Date of Death</th>
                                @endif
                            </thead>
                            @foreach($patient_clientArray as $patClient)
                            @if($patClient->branch_id != $branch->id)
                            @continue
                            @endif
                            <!-- Table Body -->
                            <tbody>
                                <tr>
                                    <!-- Patient -->
                                    <td class="table-text">
                                        <div>{{ $patClient->patient }}</div>
                                    </td>

                                    <!-- Patient Name -->
                                    <td class="table-text">
                                        <div>{{ $patClient->patientName }}</div>
                                    </td>

                                    <!-- Date of Birth -->
                                    <td class="table-text">
                                        <div>{{ $patClient->dob }}</div>
                                    </td>

                                    <!-- Breed -->
                                    <td class="table-text">
                                        <div>{{ $patClient->breed }}</div>
                                    </td>

                                    <!-- Takeon Date -->
                                    <td class="table-text">
                                        <div>{{ $patClient->takeon_date }}</div>
                                    </td>

                                    @if($patientFlag == 'Inactive Patients')
                                    <td>
                                        <div>{{ $patClient->dod }}</div>
                                    </td>
                                    @endif
                                </tr>
                            </tbody>
                            @endforeach
                            <tfoot></tfoot>
                            <tfoot>
                                <th>Total Patients :</th>
                                <th>{{ number_format($branch->total) }}</th>
                            </tfoot>
                            @endforeach
                            <tfoot>
                                <th>Grand Total :</th>
                                <th>{{ number_format($grand_total) }}</th>
                            </tfoot>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        title = "Patient Flag Report "
title = title +"\n" +"Search Flag Type: " +'{!! $patientFlag !!}'
title = title +"\n" +"Printed Date: " +'{!! $date->format('d/m/Y') !!}'
;
        $(document).ready(function() {

$('#datatable').DataTable( {

    "initComplete": function (settings, json) {
$("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
},
        paging: true,
        responsive: false,
        columnDefs: [ {
            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],

        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: null,
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: title,
                title: "Debtors Age Analysis Report",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ]

    } );
} );

    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    @endsection

    @endpush
