<!-- app/views/reports/NotBarcodedReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
<?php
$id = ($date->year . '-' . $date->month);
?>
@section('content')
@component('components.breadcrumb')
@slot('title') Not barcoded Codes @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('dashboard', $id)!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Not Barcoded Report Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Date: <strong>{{ $date->format('d/m/Y') }} {{ $date->format('H:m') }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @foreach($typeArray as $type)
                            <thead>
                                <th><strong><u>{{ $type->description }} File</u></strong></th>
                            </thead>
                            <!-- Table Headings -->
                            <thead>
                                <th>DESCRIPTION</th>
                                <th>UOM</th>
                            </thead>

                            <!-- Table Body -->
                            <tbody>
                                @foreach ($codeArray as $code)
                                @if($code->type != $type->type)
                                @continue
                                @endif
                                <tr>
                                    <! -- Description -->
                                        <td class="table-text">
                                            <div>{{ $code->description }}</div>
                                        </td>

                                        <! -- Dept -->
                                            <td class="table-text">
                                                <div>{{ $code->uom }}</div>
                                            </td>
                                </tr>
                                @endforeach
                            </tbody>
                            @endforeach
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection
    @push('plugin-scripts')

    <script>
        title = "Date: " +'{!! $date->format('d/m/Y') !!}'+"  " +'{!! $date->format('H:m') !!}'

    $(document).ready(function() {

$('#datatable').DataTable( {

    "initComplete": function (settings, json) {
$("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
},
        paging: true,
        responsive: false,
        columnDefs: [ {
            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],
        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: "Not barcoded Codes",
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: 'title',
                title: "Not barcoded Codes",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ]

    } );
} );

    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    @endsection

    @endpush
