<!-- app/views/reports/NewClientReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') New Client/Patients Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('NewClients')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- List New Clients and Patients Report Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">
                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Date: <strong>{{ $runDate->format('d/m/Y') }} New Client/Patients Report</strong></h6>
                        <h6>Branch: <strong>{{ $branch_name }}</strong></h6>
                        <h6>From: <strong>{{ $start_date->format('d/m/Y') }} To: </strong>
                            <strong>{{ $end_date->format('d/m/Y') }}</strong></h6>
                        <h6>Report By: <strong>{{ $report }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped display" id="datatable" style="width:100%">
                            @if (count($newClient) > 0)
                                <!-- Table Headings -->
                                <thead>
                                    <th>Day</th>
                                    <th>Step Date</th>
                                    <th>New Clients</th>
                                    <th>New Patients</th>
                                </thead>

                                <!-- Table Body -->
                                <tbody>
                                    @foreach ($newClient as $new)
                                        <tr>
                                            <!-- Day -->
                                            <td class="table-text">
                                                <div>{{ $new->day }}</div>
                                            </td>
                                            <!-- Step Date -->
                                            <td class="table-text">
                                                <div>{{ $new->date }}</div>
                                            </td>
                                            <!-- New Clients -->
                                            <td class="table-text">
                                                @if($new->day == 'Average:')
                                                    <div>{{ number_format($new->clientsCount, 2) }}</div>
                                                @else
                                                    <div>{{ $new->clientsCount }}</div>
                                                @endif
                                            </td>
                                            <!-- New Patients -->
                                            <td class="table-text">
                                                @if($new->day == 'Average:')
                                                    <div>{{ number_format($new->patientsCount, 2) }}</div>
                                                @else
                                                    <div>{{ $new->patientsCount }}</div>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Total</th>
                                        <th></th>
                                        <th>{{ $totNewClients }}</th>
                                        <th>{{ $totNewPatients }}</th>
                                    </tr>
                                    <tr>
                                        <th>Average</th>
                                        <th></th>
                                        <th>{{ number_format($clientAverage, 2) }}</th>
                                        <th>{{ number_format($patientAverage, 2) }}</th>
                                    </tr>
                                </tfoot>
                            @else
                                <div class="alert alert-info" role="alert">No New Client/Patients to display</div>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        $(document).ready(function() {

        var title = $('#reportHeader').html();

        title = "Date: " +'{!! $runDate->format('d/m/Y') !!}' +" New Client/Patients Report " +" <-- Should this be on new line?"
                +"\n" +" Branch: " +'{!! $branch_name !!}'
                +"\n" +" From: " +'{!! $start_date->format('d/m/Y') !!}' +" To: " +'{!! $end_date->format('d/m/Y') !!}'
                +"\n" +" Report By: " +'{!! $report !!}';

        $('#datatable').DataTable( {
            "order": [[ 1, "asc" ]],
            dom: 'lBfrtip',
            buttons: [
                'copy',
                {
                    extend: 'excel',
                    messageTop: 'reportHeader',
                    title: null
                },
                {
                    extend: 'pdf',
                    messageBottom: null,
                    messageTop: title,
                    title: "New Client/Patients Report",
                },
            ]
        } );
    } );
    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

    @endsection

    @endpush
