<!-- app/views/reports/LowSalesReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') LOW SALES (By System Type) REPORT @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('LowSales')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- List Low Sales Report Form... -->
    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">
                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>For Date Range: <strong> {{ $start_date }} </strong> To: <strong>{{ $end_date }}</strong></h6>
                        <h6>For Branches: <strong> {{ $branch }}</strong></h6>
                        @if($supplier != null)
                            <h6>For Supplier : <strong>{{ $supplier }}</strong></h6>
                        @endif
                        @if($manufacturer != null)
                            <h6>For Manufacturer : <strong>{{ $manufacturer }}</strong></h6>
                        @endif
                        <h6>Minimum Shelf Period (days): <strong>{{ $shelf_period }}</strong></h6>
                        <h6>SYSTEM TYPE: <strong>{{ $type }}</strong></h6>
                    </div>
                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @if (count($lowSalesSum) > 0)

                                <!-- Table Headings -->
                                <thead>
                                    <th>Description</th>
                                    <th>Qty-Sold</th>
                                    <th>Last Sale</th>
                                    <th>No Sales</th>
                                    <th>Cost Price</th>
                                    <th>Sales Price</th>
                                    <th>On Hand</th>
                                    <th>Sales Valuation</th>
                                    <th>Cost Valuation</th>
                                </thead>

                                <!-- Table Body -->
                                <tbody>
                                    @foreach ($lowSalesSum as $lowSale)
                                        <tr>
                                            <!-- Stock Type -->
                                            <td class="table-text">
                                                <div>{{ $lowSale->description }}</div>
                                            </td>
                                            <!-- Sales -->
                                            <td class="table-text">
                                                <div>{{ $lowSale->qty_sold }}</div>
                                            </td>
                                            <!-- Last sale -->
                                            <td class="table-text">
                                                <div>{{ $lowSale->last_sale }}</div>
                                            </td>
                                            <!-- No Sales -->
                                            <td class="table-text">
                                                <div>{{ $lowSale->no_sales }}</div>
                                            </td>
                                            <!-- Cost Price -->
                                            <td class="table-text">
                                                <div>{{ number_format($lowSale->cost_price, 2) }}</div>
                                            </td>
                                            <!-- Sales Price -->
                                            <td class="table-text">
                                                <div>{{ number_format($lowSale->sales_price, 2) }}</div>
                                            </td>
                                            <!-- Quantity on hand -->
                                            <td class="table-text">
                                                <div>{{ $lowSale->on_hand }}</div>
                                            </td>
                                            <!-- Sales Valuation -->
                                            <td class="table-text">
                                                <div>{{ number_format($lowSale->sales_valuation, 2) }}</div>
                                            </td>
                                            <!-- Cost Valuation -->
                                            <td class="table-text">
                                                <div>{{ number_format($lowSale->cost_valuation, 2) }}</div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Total</th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th>{{ number_format($sales_valuation, 2) }}</th>
                                        <th>{{ number_format($cost_valuation, 2) }}</th>
                                    </tr>
                                </tfoot>
                            @else
                                <div class="alert alert-info" role="alert">No Sales are available</div>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endsection

    @push('plugin-scripts')

    <script>
        title = "For Date Range: " +'{!! $start_date !!}' +" To: " +'{!! $end_date !!}'
    +"\n" +"For Branches: " +'{!! $branch !!}';
    if('{!! $supplier !!}')
    {
        title = title +"\n" +"For Supplier : " +'{!! $supplier !!}'
    }
    if('{!! $manufacturer !!}')
    {
        title = title +"\n" +"For Manufacturer : " +'{!! $manufacturer !!}'
    }
    title = title +"\n" +"Minimum Shelf Period (days): " +'{!! $shelf_period !!}'
    +"\n" +"SYSTEM TYPE: " +'{!! $type !!}';

    $(document).ready(function() {
        var printCounter = 0;
        $('#datatable').DataTable( {

        columnDefs: [ {
            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],
        dom: 'lBfrtip',
            buttons: [
                'copy',
                {
                    extend: 'excel',
                    messageTop: 'reportHeader',
                    title: null
                },
                {
                    extend: 'pdf',
                    messageBottom: null,
                    messageTop: title,
                    title: "LOW SALES (By System Type) REPORT",
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ]
        } );
    } );
    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="//cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

    @endsection

    @endpush
