<!-- app/views/reports/DebtorsAgeAnalysis.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Debtors Age Analysis Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('DebtorsAge')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- List Debtors Age Analysis Report Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>{{ $heading }}</h6>
                        <h6>For Branches: <strong>{{ $branch_name }}</strong></h6>
                        @if($badDebtorsNote != null)
                        <h6>{{ $badDebtorsNote }}</h6>
                        @endif
                        @if($debtorAgeNote != null)
                        <h6>{{ $debtorAgeNote }}</h6>
                        @endif
                        <h6>Printed On: <strong>{{ $date->format('d/m/Y') }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @if (count($debtorAge) > 0)
                            <!-- Table Headings -->
                            <thead>
                                <th>Customer</th>
                                <th>Surname</th>
                                <th>Init</th>
                                @if($addTelNo == 'Yes')
                                <th>Telephone No</th>
                                <th>Mobile No</th>
                                @endif
                                <th>Last Pmt Date</th>
                                <th>Last Pmt Amt</th>
                                <th>Current</th>
                                <th>30 Days</th>
                                <th>60 Days</th>
                                <th>90 Days</th>
                                <th>120 Days+</th>
                                <th>Total</th>
                            </thead>

                            @foreach ($debtorAge as $debtAge)
                            <!-- Table Body -->
                            <tbody>
                                <tr>
                                    <!-- Customer No -->
                                    <td class="table-text">
                                        <div>{{ $debtAge->customer }}</div>
                                    </td>
                                    <!-- Surname -->
                                    <td class="table-text">
                                        <div>{{ $debtAge->surname }}</div>
                                    </td>
                                    <!--Initials -->
                                    <td class="table-text">
                                        <div>{{ $debtAge->initials }}</div>
                                    </td>
                                    @if($addTelNo == 'Yes')
                                    <!-- Telephone No -->
                                    <td class="table-text">
                                        <div>{{ $debtAge->telNo }}</div>
                                    </td>
                                    <!-- Mobile No -->
                                    <td class="table-text">
                                        <div>{{ $debtAge->mobileNo }}</div>
                                    </td>
                                    @endif
                                    <!-- Last Payment Date -->
                                    <td class="table-text">
                                        <div>{{ $debtAge->lastPmtDate }}</div>
                                    </td>
                                    <!-- Last Payment Amt -->
                                    <td class="table-text">
                                        <div>{{ $debtAge->lastPmtAmt }}</div>
                                    </td>
                                    <!-- Current-->
                                    <td class="table-text">
                                        <div>{{ $debtAge->current }}</div>
                                    </td>
                                    <!-- 30 Days -->
                                    <td class="table-text">
                                        <div>{{ $debtAge->days30 }}</div>
                                    </td>
                                    <!-- 60 Days -->
                                    <td class="table-text">
                                        <div>{{ $debtAge->days60 }}</div>
                                    </td>
                                    <!-- 90 Days -->
                                    <td class="table-text">
                                        <div>{{ $debtAge->days90 }}</div>
                                    </td>
                                    <!-- 120 Days -->
                                    <td class="table-text">
                                        <div>{{ $debtAge->days120 }}</div>
                                    </td>
                                    <!--Total -->
                                    <td class="table-text">
                                        <div>{{ $debtAge->total }}</div>
                                    </td>
                                </tr>
                            </tbody>
                            @endforeach
                            <tfoot>
                                <tr>
                                    <th></th>
                                    <th>Total</th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th>{{ number_format($curTot, 2) }}</th>
                                    <th>{{ number_format($age30Tot, 2) }}</th>
                                    <th>{{ number_format($age60Tot, 2) }}</th>
                                    <th>{{ number_format($age90Tot, 2) }}</th>
                                    <th>{{ number_format($age120Tot, 2) }}</th>
                                    <th>{{ number_format($grand_total, 2) }}</th>
                                </tr>
                                <tr>
                                    <th></th>
                                    <th>Percentage Split</th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th>{{ number_format($curTot / $grand_total * 100 , 2) }}</th>
                                    <th>{{ number_format($age30Tot / $grand_total * 100, 2) }}</th>
                                    <th>{{ number_format($age60Tot / $grand_total * 100, 2) }}</th>
                                    <th>{{ number_format($age90Tot / $grand_total * 100, 2) }}</th>
                                    <th>{{ number_format($age120Tot / $grand_total * 100, 2) }}</th>
                                    <th></th>
                                </tr>
                            </tfoot>
                            @else
                            <div class="alert alert-info" role="alert">No Debtors Age Analysis Report to display</div>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        // PDF Export button heading information
        title = '{!! $heading !!}';
        title = title +"\n" +"For Branches: " +'{!! $branch_name !!}';
    if('{!! $badDebtorsNote !!}')
    {
        title = title +"\n" +'{!! $badDebtorsNote !!}'
    }
    if('{!! $debtorAgeNote !!}')
    {
    title = title +"\n" +'{!! $debtorAgeNote !!}'
    }
    title = title +"\n" +"Printed On: " +'{!! $date->format('d/m/Y') !!}'
    ;

    $(document).ready(function() {

    $('#datatable').DataTable( {

        "initComplete": function (settings, json) {
    $("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
  },

        paging: true,
        responsive: false,
        columnDefs: [ {
            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],

        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: null,
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: title,
                title: "Debtors Age Analysis Report",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ]

    } );
} );

    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    @endsection

    @endpush
