<!-- app/views/reports/DailyStockReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Day to Day Stock Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a
        href="{!!URL::route('DailyStockTracker')!!}">BACK</a> @endslot
    @endcomponent
    <!-- Create Day to Day Stock Report... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">
                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>For Stock Type: <strong>{{ $type->description }}</strong></h6>
                        <h6>For Warehouse: <strong>{{ $warehouse->name }}</strong></h6>
                        <h6>Date Range: <strong>{{ $start_date }}</strong> To: <strong>{{ $end_date }}</strong></h6>
                        <h6>Report Date: <strong>{{ $repDate->format('d/m/Y') }}</strong> At:
                            <strong>{{ $repDate->format('H:m') }}</strong>
                        </h6>
                        <h6><strong>{{ $code->description }} {{ $code->uom }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <div class="table-responsive">
                            <table class="display nowrap" id="datatable" style="width:100%" width="100%">
                                @if (count($stockdRep) > 0)

                                <!-- Table Headings -->
                                <thead>
                                    <th>Date</th>
                                    <th>Opening</th>
                                    <th>Sold</th>
                                    <th>Received</th>
                                    <th>Adjusted</th>
                                    <th>Returned</th>
                                    <th>Closing</th>
                                </thead>

                                <!-- Table Body -->
                                <tbody>
                                    @foreach ($stockdRep as $stckd)
                                    @if(count($adjustRecs) > 0)
                                    @foreach($adjustRecs as $adjustRec)
                                    @if($adjustRec->adjust_date == $stckd->stock_date)
                                    <tr>
                                        <td class="table-text">
                                            <div></div>
                                        </td>
                                        <td class="table-text">
                                            <div>{{ $adjustRec->adjust_rec }}</div>
                                        </td>
                                    </tr>
                                    @endif
                                    @endforeach
                                    @endif
                                    <tr>
                                        <!-- Stock Date -->
                                        <td class="table-text">
                                            <div>{{ $stckd->stock_date }}</div>
                                        </td>
                                        <!-- Opening Qty -->
                                        <td class="table-text">
                                            <div>{{ number_format($stckd->opening_qty, 2) }}</div>
                                        </td>
                                        <!-- Sold Qty -->
                                        <td class="table-text">
                                            <div>{{ number_format($stckd->sold_qty, 2) }}</div>
                                        </td>
                                        <!-- Received Qty -->
                                        <td class="table-text">
                                            <div>{{ number_format($stckd->received_qty, 2) }}</div>
                                        </td>
                                        <!-- Adjusted Qty -->
                                        <td class="table-text">
                                            <div>{{ number_format($stckd->adjusted_qty, 2) }}</div>
                                        </td>
                                        <!-- Returned Qty -->
                                        <td class="table-text">
                                            <div>{{ number_format($stckd->returned_qty, 2) }}</div>
                                        </td>
                                        <!-- Closing Qty -->
                                        <td class="table-text">
                                            <div>{{ number_format($stckd->closing_qty, 2) }}</div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                @else
                                <div class="alert alert-info" role="alert">No day to day stock to report</div>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        var title = $('#reportHeader').html();

title = "For Stock Type: " +'{!! $type->description !!}'
title = title +"\n" +"For Warehouse: " +'{!! $warehouse->name !!}'
title = title +"\n" +"Date Range: " +'{!! $start_date !!}' +" To: " +'{!! $end_date !!}'
title = title +"\n" +"Report Date: " +'{!! $repDate->format('d/m/Y') !!}' +" At: " +'{!! $repDate->format('H:m') !!}'
title = title +"\n" +'{!! $code->description !!}' +'{!! $code->uom !!}'
;

    $(document).ready(function() {
        var printCounter = 0;
        var table = $('#datatable').DataTable({

        dom: 'lBfrtip',


        buttons: [

            'copyHtml5',
            {
                extend: 'excel',
                messageBottom: null,
                title: 'Day to Day Stock Report',

            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: title,
                title: 'Day to Day Stock Report',
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },
            'csvHtml5',

        ],
        "scrollX": true,
        responsive: false,

 } );
} );
    </script>

    @section('script')



    <link href="https://nightly.datatables.net/css/jquery.dataTables.css" rel="stylesheet" type="text/css" />
    <script src="https://nightly.datatables.net/js/jquery.dataTables.js"></script>

    <!-- Begin - adding buttons -->


    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

    <!-- Print -->
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

    <!-- Page length (button) -->

    <script src=""></script>

    <!-- End - adding buttons -->

    @endsection

    @endpush
