<!-- app/views/reports/ClientDiscountReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Client Discount Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('ClientDiscount')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Branch Gross Report Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Date Range From: <strong>{{ $start_date }}</strong> To: <strong>{{ $end_date }}</strong>
                        </h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @if (count($clientDisc) > 0)
                            @foreach($branchArray as $branch)
                            <thead>
                                <th><strong>Branch : {{ $branch->branch_name }}</strong></th>
                            </thead>
                            <!-- Table Headings -->
                            <thead>
                                <th>Invoice</th>
                                <th>Customer</th>
                                <th>Date</th>
                                <th>Type</th>
                                <th>Reference</th>
                                <th>Rep</th>
                                <th>Cost</th>
                                <th>Amount</th>
                                <th>Discount</th>
                                <th>Disc %</th>
                            </thead>

                            <!-- Table Body -->
                            <tbody>
                                @foreach ($clientDisc as $client)
                                @if($client->branch != $branch->id)
                                @continue
                                @endif
                                <tr>
                                    <!-- Invoice -->
                                    <td class="table-text">
                                        <div>{{ $client->invoice }}</div>
                                    </td>
                                    <!-- Customer -->
                                    <td class="table-text">
                                        <div>{{ $client->customer }}</div>
                                    </td>
                                    <!-- Date -->
                                    <td class="table-text">
                                        <div>{{ $client->inv_date }}</div>
                                    </td>
                                    <!-- Type -->
                                    <td class="table-text">
                                        <div>{{ $client->type }}</div>
                                    </td>
                                    <!-- Reference -->
                                    <td class="table-text">
                                        <div>{{ $client->reference }}</div>
                                    </td>
                                    <!-- Rep -->
                                    <td class="table-text">
                                        <div>{{ $client->user }}</div>
                                    </td>
                                    <!-- Cost -->
                                    <td class="table-text">
                                        <div>{{ number_format($client->cost, 2) }}</div>
                                    </td>
                                    <!-- Amount -->
                                    <td class="table-text">
                                        <div>{{ number_format($client->amount, 2) }}</div>
                                    </td>
                                    <!-- Discount -->
                                    <td class="table-text">
                                        <div>{{ number_format($client->discount, 2) }}</div>
                                    </td>
                                    <!-- Discount Percent -->
                                    <td class="table-text">
                                        @if($client->disc_perc != '?????')
                                        <div>{{ number_format($client->disc_perc, 2) }} %</div>
                                        @else
                                        <div>{{ $client->disc_perc }}</div>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            <tfoot></tfoot>
                            <tfoot>
                                <th>Branch Total</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>{{ number_format($branch->cost, 2) }}</th>
                                <th>{{ number_format($branch->amount, 2) }}</th>
                                <th>{{ number_format($branch->discount, 2) }}</th>
                                <th>{{ number_format($branch->discount_perc, 2) }} %</th>
                            </tfoot>
                            </tbody>
                            @endforeach
                            @else
                            <div class="alert alert-info" role="alert">No Client Discount report to display</div>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        // PDF Export button heading information
        title = "Date Range From: " +'{!! $start_date !!}'+"To: " +'{!! $end_date !!}';
    ;

        $(document).ready(function() {

    $('#datatable').DataTable( {

        "initComplete": function (settings, json) {
    $("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
  },

        paging: true,
        responsive: false,
        columnDefs: [ {
            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],

        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: "Client Discount Report",
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: title,
                title: "Client Discount Report",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ]

    } );
} );

    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    @endsection

    @endpush
