<!-- app/views/reports/BranchGrossReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Branch Gross Profit Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a
        href="{!!URL::route('BranchGrossProfit')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Branch Gross Report Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Branch Gross Profit Percentage Report For Period: <strong>{{ $start_date }}</strong> To:
                            <strong>{{ $end_date }}</strong>
                        </h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @if (count($salesReport) > 0)
                            @foreach($branchArray as $branch)
                            @if($branch->branch_id == 'A')
                            @continue
                            @endif
                            <thead>
                                <th><strong>Branch : {{ $branch->branch_name }}</strong></th>
                            </thead>
                            <!-- Table Headings -->
                            <thead>
                                <th>Description</th>
                                <th>Amount</th>
                                <th>C.O.S</th>
                                <th>Profit</th>
                                <th>GP %</th>
                            </thead>

                            <!-- Table Body -->
                            <tbody>
                                @foreach ($salesReport as $sales)
                                @if($sales->vet != $branch->branch_id)
                                @continue
                                @endif
                                <tr>
                                    <!-- Description -->
                                    <td class="table-text">
                                        <div>{{ $sales->type }}</div>
                                    </td>
                                    <!-- Amount -->
                                    <td class="table-text">
                                        <div>{{ number_format($sales->amount, 2) }}</div>
                                    </td>
                                    <!-- Cost -->
                                    <td class="table-text">
                                        <div>{{ number_format($sales->cost, 2) }}</div>
                                    </td>
                                    <!-- Profit -->
                                    <td class="table-text">
                                        <div>{{ number_format($sales->gross, 2) }}</div>
                                    </td>
                                    <!-- GP Percent -->
                                    @if($sales->amount != 0)
                                    <td class="table-text">
                                        <div>{{ number_format(($sales->gross / $sales->amount * 100), 2) }}</div>
                                    </td>
                                    @else
                                    <td class="table-text">
                                        <div>{{ 0.00 }}</div>
                                    </td>
                                    @endif
                                </tr>
                                @endforeach
                            <tfoot></tfoot>
                            <tfoot>
                                <th>Branch Total</th>
                                <th>{{ number_format($branch->branch_amt, 2) }}</th>
                                <th>{{ number_format($branch->branch_cost, 2) }}</th>
                                <th>{{ number_format($branch->branch_gross, 2) }}</th>
                                @if($branch->branch_amt != 0)
                                <th>{{ number_format(($branch->branch_gross / $branch->branch_amt * 100), 2) }}</th>
                                @else
                                <th>{{ 0.00 }}</th>
                                @endif
                            </tfoot>
                            </tbody>
                            @endforeach
                            <tfoot></tfoot>
                            <tfoot>
                                <th>Grand Totals</th>
                                <th>{{ number_format($grand_amt, 2) }}</th>
                                <th>{{ number_format($grand_cost, 2) }}</th>
                                <th>{{ number_format($grand_profit, 2) }}</th>
                                @if($grand_amt != 0)
                                <th>{{ number_format(($grand_profit / $grand_amt * 100), 2) }}</th>
                                @else
                                <th>{{ 0.00 }}</th>
                                @endif
                            </tfoot>
                            <thead>
                                <th>Summary</th>
                            </thead>
                            <thead>
                                <th>Description</th>
                                <th>Amt</th>
                                <th>COS</th>
                                <th>Profit</th>
                                <th>GP%</th>
                                <th>Amt %</th>
                                <th>COS %</th>
                                <th>Profit %</th>
                            </thead>
                            @foreach ($salesBranchReport as $sales)
                            <tr>
                                <!-- Description -->
                                <td class="table-text">
                                    <div>{{ $sales->type }}</div>
                                </td>
                                <!-- Amount -->
                                <td class="table-text">
                                    <div>{{ number_format($sales->amount, 2) }}</div>
                                </td>
                                <!-- Cost -->
                                <td class="table-text">
                                    <div>{{ number_format($sales->cost, 2) }}</div>
                                </td>
                                <!-- Profit -->
                                <td class="table-text">
                                    <div>{{ number_format($sales->gross, 2) }}</div>
                                </td>
                                <!-- GP % -->
                                @if($sales->amount != 0)
                                <td class="table-text">
                                    <div>{{ number_format(($sales->gross / $sales->amount * 100), 2) }}</div>
                                </td>
                                @else
                                <td class="table-text">
                                    <div>{{ 0.00 }}</div>
                                </td>
                                @endif
                                <!-- Amount -->
                                @if($grand_amt != 0)
                                <td class="table-text">
                                    <div>{{ number_format(($sales->amount / $grand_amt * 100), 2) }}</div>
                                </td>
                                @else
                                <td class="table-text">
                                    <div>{{ 0.00 }}</div>
                                </td>
                                @endif
                                <!-- Cost -->
                                @if($grand_cost != 0)
                                <td class="table-text">
                                    <div>{{ number_format(($sales->cost / $grand_cost * 100), 2) }}</div>
                                </td>
                                @else
                                <td class="table-text">
                                    <div>{{ 0.00 }}</div>
                                </td>
                                @endif
                                <!-- Profit -->
                                @if($grand_profit != 0)
                                <td class="table-text">
                                    <div>{{ number_format(($sales->gross / $grand_profit * 100), 2) }}</div>
                                </td>
                                @else
                                <td class="table-text">
                                    <div>{{ 0.00 }}</div>
                                </td>
                                @endif
                            </tr>
                            @endforeach
                            <tfoot></tfoot>
                            <tfoot>
                                <th>Totals</th>
                                <th>{{ number_format($grand_amt, 2) }}</th>
                                <th>{{ number_format($grand_cost, 2) }}</th>
                                <th>{{ number_format($grand_profit, 2) }}</th>
                                @if($grand_amt != 0)
                                <th>{{ number_format(($grand_profit / $grand_amt * 100), 2) }}</th>
                                @else
                                <th>{{ 0.00 }}</th>
                                @endif
                            </tfoot>
                            @else
                            <div class="alert alert-info" role="alert">No branch gross to display</div>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        // PDF Export button heading information
        title = "Branch Gross Profit Percentage Report For Period: " +'{!! $start_date !!}'+"To: " +'{!! $end_date !!}';
    ;

        $(document).ready(function() {
$('#datatable').DataTable( {
dom: 'Blfrtip',
buttons: [
'copy', 'csv', 'excel', 'pdf', 'print'
],
"lengthMenu": [
  [10, 25, 50, -1], [10, 25, 50, "All"]
],
} );
} );
    </script>

    @section('script')

    <link href="https://nightly.datatables.net/css/jquery.dataTables.css" rel="stylesheet" type="text/css" />
    <script src="https://nightly.datatables.net/js/jquery.dataTables.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.2.2/js/buttons.html5.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/vfs_fonts.js"></script>
    <link href="https://cdn.datatables.net/buttons/1.5.1/css/buttons.dataTables.css" rel="stylesheet" type="text/css" />
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.colVis.min.js"></script>
    <script type="text/javascript" language="javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.colVis.min.js"></script>



    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css"
        integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <link rel="stylesheet" type="text/css"
        href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.2/css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.22/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" type="text/css"
        href="https://cdn.datatables.net/buttons/1.6.5/css/buttons.dataTables.min.css">

    <script type="text/javascript" language="javascript" src="index.js"></script>
    @endsection

    @endpush
