<!-- app/views/reports/BankingSummaryReport2.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Banking Summary Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('BankingSummary')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Banking Summary Report Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Branch: <strong>{{ $branch }}</strong></h6>
                        <h6>Date From: <strong>{{ $start_date }}</strong> To: <strong>{{ $end_date }}</strong></h6>
                        <h6>Printed Date: <strong>{{ $date->format('d/m/Y') }}</strong> Time:
                            <strong>{{ $date->format('H:m') }}</strong>
                        </h6>
                    </div>
                    {{-- <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @if (count($banksumDet) > 0)
                            @foreach($bankArray as $payType)
                            <!-- Table Headings -->
                            <thead>
                                <th><strong>{{ $payType->paymentType }}</strong></th>
                            </thead>
                            <thead>
                                <th>CustNo</th>
                                <th>Surname</th>
                                <th>Reference</th>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>Discount</th>
                            </thead>

                            @foreach ($banksumDet as $bankDet)

                            @if($bankDet->paymentType != $payType->paymentType)
                            @continue
                            @endif

                            <!-- Table Body -->
                            <tbody>
                                <tr>
                                    <!-- Customer -->
                                    <td class="table-text">
                                        <div>{{ $bankDet->customer }}</div>
                                    </td>

                                    <!-- Surname -->
                                    <td class="table-text">
                                        <div>{{ $bankDet->surname }}</div>
                                    </td>

                                    <!-- Reference -->
                                    <td class="table-text">
                                        <div>{{ $bankDet->reference }}</div>
                                    </td>

                                    <!-- Date -->
                                    <td class="table-text">
                                        <div>{{ $bankDet->bank_date }}</div>
                                    </td>

                                    <!-- Amount -->
                                    <td class="table-text">
                                        <div>{{ number_format($bankDet->amount, 2) }}</div>
                                    </td>

                                    <!-- Discount -->
                                    <td class="table-text">
                                        <div>{{ number_format($bankDet->discount, 2) }}</div>
                                    </td>
                                </tr>
                            </tbody>
                            @endforeach
                            <tfoot></tfoot>

                            <tfoot>
                                <th>Sub Total</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>{{ number_format($payType->amount, 2) }}</th>
                                <th>{{ number_format($payType->discount, 2) }}</th>
                            </tfoot>
                            @endforeach
                            <tfoot>
                                <th>Grand Total</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>{{ number_format($grand_amount, 2) }}</th>
                                <th>{{ number_format($grand_discount, 2) }}</th>
                            </tfoot>
                            @endif
                        </table>
                    </div> --}}

                    {{-- test BEGIN --}}
                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @if (count($banksumDet) > 0)
                            @foreach($bankArray as $payType)
                            <!-- Table Headings -->

                            <thead>
                                <tr>
                                    <th>Payment Type</th>
                                    <th>CustNo</th>
                                    <th>Surname</th>
                                    <th>Reference</th>
                                    <th>Date</th>
                                    <th>Amount</th>
                                    <th>Discount</th>
                                </tr>
                            </thead>

                            @foreach ($banksumDet as $bankDet)

                            @if($bankDet->paymentType != $payType->paymentType)
                            @continue
                            @endif

                            <!-- Table Body -->
                            <tbody>
                                <tr>

                                    <td class="table-text">
                                        <div>{{ $payType->paymentType }}</div>
                                    </td>

                                    <!-- Customer -->
                                    <td class="table-text">
                                        <div>{{ $bankDet->customer }}</div>
                                    </td>

                                    <!-- Surname -->
                                    <td class="table-text">
                                        <div>{{ $bankDet->surname }}</div>
                                    </td>

                                    <!-- Reference -->
                                    <td class="table-text">
                                        <div>{{ $bankDet->reference }}</div>
                                    </td>

                                    <!-- Date -->
                                    <td class="table-text">
                                        <div>{{ $bankDet->bank_date }}</div>
                                    </td>

                                    <!-- Amount -->
                                    <td class="table-text">
                                        <div>{{ number_format($bankDet->amount, 2) }}</div>
                                    </td>

                                    <!-- Discount -->
                                    <td class="table-text">
                                        <div>{{ number_format($bankDet->discount, 2) }}</div>
                                    </td>
                                </tr>
                                @endforeach
                                <tr>
                                    <td>Sub Total</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td>{{ number_format($payType->amount, 2) }}</td>
                                    <td>{{ number_format($payType->discount, 2) }}</td>
                                </tr>
                                @endforeach
                            </tbody>

                            <tfoot>
                                <tr>
                                    <th>Grand Total</th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th>{{ number_format($grand_amount, 2) }}</th>
                                    <th>{{ number_format($grand_discount, 2) }}</th>
                                <tr>
                            </tfoot>
                            @endif
                        </table>
                    </div>
                    {{-- test END --}}
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        var title = $('#reportHeader').html();
        title = "Branch: " +'{{!! $branch !!}}'
        title = title +"\n" +"Date From: " +'{{!! $start_date !!}}' +" To: " +'{{!! $end_date !!}}'
        title = title +"\n" +"Printed Date: " +'{{!! $date->format('d/m/Y') !!}}' " Time: " +'{{!! $date->format('H:m') !!}}'
;

    $(document).ready(function() {
        var printCounter = 0;
        var table = $('#datatable').DataTable({

        dom: 'lBfrtip',


        buttons: [

            'copyHtml5',
            {
                extend: 'excel',
                messageBottom: null,
                title: 'Banking Summary Report',

            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: title,
                title: 'Banking Summary Report',
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },
            'csvHtml5',

        ],
        "scrollX": true,
        responsive: false,

 } );
} );
    </script>

    @section('script')



    <link href="https://nightly.datatables.net/css/jquery.dataTables.css" rel="stylesheet" type="text/css" />
    <script src="https://nightly.datatables.net/js/jquery.dataTables.js"></script>

    <!-- Begin - adding buttons -->


    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

    <!-- Print -->
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

    <!-- Page length (button) -->

    <script src=""></script>

    <!-- End - adding buttons -->

    @endsection

    @endpush
