<!-- app/views/reports/AverageVetSummary.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Average Invoice Value By Vet @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('AverageConsult')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Average Consults By Vet Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">
                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Report: <strong>{{ $repDate->format('d/m/Y') }} {{ $repDate->format('H:m') }}</strong></h6>
                        <h6>Consult Break Down Report</h6>
                        <h6>From: <strong>{{ $start_date }}</strong> To: <strong>{{ $end_date }}</strong></h6>
                        <h6>Branch: <strong>{{ $branch_name }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped display" id="datatable" style="width:100%">
                            @if (count($vetconArray) > 0)

                            @foreach ($vetconArray as $vetcon)

                            <!-- Table Headings -->
                            <thead>
                                <th>Vet: <strong>{{ $vetcon->vet }}</strong></th>
                            </thead>
                            <thead>
                                <th>Invoice</th>
                                <th>Amount</th>
                                <th>Discount</th>
                                <th>Vat</th>
                                <th>Total</th>
                            </thead>

                            <!-- Table Body -->
                            <tbody>
                                <tr>
                                    <!-- Invoice -->
                                    <td class="table-text">
                                        <div>{{ $vetcon->invoice }}</div>
                                    </td>

                                    <!-- Amount -->
                                    <td class="table-text">
                                        <a href="{!!URL::route('AverageConsultsBreakdown', ['vet' => $vetcon->vet,
                                                    'start_date' => $start_date, 'end_date' => $end_date, 'branch' =>
                                                    $vetcon->branch])!!}" class="font-weight-medium text-primary">
                                            <strong>{{ number_format($vetcon->amount, 2) }}</strong></a>
                                    </td>

                                    <!-- Discount -->
                                    <td class="table-text">
                                        <div>{{ number_format($vetcon->discount, 2) }}</div>
                                    </td>

                                    <!-- VAT -->
                                    <td class="table-text">
                                        <div>{{ number_format($vetcon->vat, 2) }}</div>
                                    </td>

                                    <!-- Total -->
                                    <td class="table-text">
                                        <div>{{ number_format($vetcon->total, 2) }}</div>
                                    </td>
                                </tr>
                            </tbody>
                            <tfoot></tfoot>

                            <tfoot>
                                <th>Average</th>
                                <th>{{ number_format($vetcon->averageAmt, 2) }}</th>
                                <th>{{ number_format($vetcon->averageDisc, 2) }}</th>
                                <th>{{ number_format($vetcon->averageVAT, 2) }}</th>
                                <th>{{ number_format($vetcon->averageTotal, 2) }}</th>
                            </tfoot>
                            <tfoot>
                                <th>Number of Invoices</th>
                                <th>{{ $vetcon->count }}</th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tfoot>
                            @endforeach
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endsection

    @push('plugin-scripts')

    <script>
        // PDF Export button heading information

    title = "Report: " +'{{!! $repDate->format('d/m/Y') !!}}' +'{!! $repDate->format('H:m') !!}'
    title = title +"\n" +"Consult Break Down Report: "
    title = title +"\n" +"From: " +'{{!! $start_date !!}}' +"To: " +'{{!! $end_date !!}}'
    title = title +"\n" +"Branch: " +'{{!! $branch_name !!}}'
;

$(document).ready(function() {
        var printCounter = 0;
        var table = $('#datatable').DataTable({

        dom: 'lBfrtip',


        buttons: [

            'copyHtml5',
            {
                extend: 'excel',
                messageBottom: null,
                title: 'Day to Day Stock Report',

            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: title,
                title: 'Day to Day Stock Report',
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },
            'csvHtml5',

        ],
        "scrollX": true,
        responsive: false,

 } );
} );
    </script>

    @section('script')



    <link href="https://nightly.datatables.net/css/jquery.dataTables.css" rel="stylesheet" type="text/css" />
    <script src="https://nightly.datatables.net/js/jquery.dataTables.js"></script>

    <!-- Begin - adding buttons -->


    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

    <!-- Print -->
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

    <!-- Page length (button) -->

    <script src=""></script>

    <!-- End - adding buttons -->

    @endsection

    @endpush
