<!-- app/views/reports/AverageConsultsReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Average Invoice Value By Vet @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('AverageConsult')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Average Consults By Vet Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">
                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Report: <strong>{{ $repDate->format('d/m/Y') }} {{ $repDate->format('H:m') }}</strong></h6>
                        <h6>From: <strong>{{ $start_date }}</strong> To: <strong>{{ $end_date }}</strong></h6>
                        <h6>Branch: <strong>{{ $branch_name }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped display" id="datatable" style="width:100%">
                            @if (count($vetconArray) > 0)
                            @foreach($vetconTots as $vet)

                            <!-- Table Headings -->
                            <thead>
                                <th>Vet: <strong>{{ $vet->user_name }}</strong></th>
                            </thead>
                            <thead>
                                <th>Invoice</th>
                                <th>Amount</th>
                                <th>Discount</th>
                                <th>Vat</th>
                                <th>Total</th>
                            </thead>

                            @foreach ($vetconArray as $vetcon)

                            @if($vetcon->vet != $vet->user_name)
                            @continue
                            @endif

                            <!-- Table Body -->
                            <tbody>
                                <tr>
                                    <!-- Invoice -->
                                    <td class="table-text">
                                        <div>{{ $vetcon->invoice }}</div>
                                    </td>

                                    <!-- Amount -->
                                    <td class="table-text">
                                        <div>{{ number_format($vetcon->amount, 2) }}</div>
                                    </td>

                                    <!-- Discount -->
                                    <td class="table-text">
                                        <div>{{ number_format($vetcon->discount, 2) }}</div>
                                    </td>

                                    <!-- VAT -->
                                    <td class="table-text">
                                        <div>{{ number_format($vetcon->vat, 2) }}</div>
                                    </td>

                                    <!-- Total -->
                                    <td class="table-text">
                                        <div>{{ number_format($vetcon->total, 2) }}</div>
                                    </td>
                                </tr>
                            </tbody>
                            @endforeach

                            <tr>
                                <th>Average</th>
                                <th>{{ number_format($vet->averageAmt, 2) }}</th>
                                <th>{{ number_format($vet->averageDisc, 2) }}</th>
                                <th>{{ number_format($vet->averageVAT, 2) }}</th>
                                <th>{{ number_format($vet->averageTotal, 2) }}</th>
                            </tr>
                            <tr>
                                <th>Number of Invoices</th>
                                <th>{{ $vet->count }}</th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                            @endforeach
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endsection

    @push('plugin-scripts')


    <script>
        var title = $('#reportHeader').html();

title = "Report: " +'{{!! $repDate->format('d/m/Y') !!}}'
title = title +"\n" +"From: " +'{{!! $start_date !!}}'+" to: " +'{{!! $end_date !!}}'
title = title +"\n" +"Branch: " +'{{!! $branch_name !!}}'
;


$(document).ready(function() {
    var printCounter = 0;
    var table = $('#datatable').DataTable({

    dom: 'lBfrtip',


    buttons: [

        'copyHtml5',
        {
            extend: 'excel',
            messageBottom: null,
            title: 'Day to Day Stock Report',

        },
        {
            extend: 'pdfHtml5',
            messageBottom: null,
            messageTop: title,
            title: 'Day to Day Stock Report',
            orientation: 'landscape',
            pageSize: 'LEGAL'
        },
        'csvHtml5',

    ],
    "scrollX": true,
    responsive: false,

} );
} );
    </script>

    @section('script')



    <link href="https://nightly.datatables.net/css/jquery.dataTables.css" rel="stylesheet" type="text/css" />
    <script src="https://nightly.datatables.net/js/jquery.dataTables.js"></script>

    <!-- Begin - adding buttons -->


    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

    <!-- Print -->
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

    <!-- Page length (button) -->

    <script src=""></script>

    <!-- End - adding buttons -->

    @endsection

    @endpush
