<!-- app/views/eid/edit.blade.php -->

@extends('layout/app')

@section('content')
    <!-- Edit EID Form... -->

    <div class="page-content d-flex align-items-center justify-content-center">

        <div class="row w-100 mr-5 auth-page">
            <div class="col-md-8 col-xl-6 mx-auto">
                <div class="card">
                    <div class="card-body">

                        <h4 class="mb-3">Update Enterprise: {!! $eid->name !!}</h4>

                        <div class="col-md-8">
                            <!-- if there are creation errors, they will show here -->
                            {!! HTML::ul($errors->all()) !!}

                            {!! Form::model($eid, ['method' => 'PATCH', 'route' => ['updateEID', $eid->id]]) !!}

                            <div class="form-group form-group-sm">
                                {!! Form::label('name', 'Name') !!}
                                {!! Form::text('name', $eid->name, array('class' => 'form-control form-control-sm
                                input-sm', 'required')) !!}
                            </div>

                            <div class="form-group form-group-sm">
                                {!! Form::label('enterprise_id', 'EID') !!}
                                {!! Form::text('enterprise_id', $eid->enterprise_id, array('class' => 'form-control
                                form-control-sm input-sm', 'required')) !!}
                            </div>

                            <div class="form-group form-group-sm">
                                {!! Form::label('schemaName', 'Schema Name') !!}
                                {!! Form::text('schemaName', $eid->schemaName, array('class' => 'form-control form-control-sm
                                input-sm', 'required')) !!}
                            </div>

                            <a href="{!!URL::route('eids')!!}" class="btn btn-sm btn-secondary" role="button">Cancel</a>
                            {!! Form::submit('Update', array('class' => 'btn btn-sm btn-info')) !!}
                            {!! Form::close() !!}

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection