<!-- app/views/eid/create.blade.php -->

@extends('layout/app')

@section('content')
    <!-- Create EID Form... -->
    <div class="page-content d-flex align-items-center justify-content-center">

        <div class="row w-100 mr-5 auth-page">
            <div class="col-md-8 col-xl-6 mx-auto">
                <div class="card">
                    <div class="card-body">

                        <h4 class="mb-3">Add New Enterprise ID</h4>

                        <!-- if there are creation errors, they will show here -->

                        <div class="col-md-8">

                            <!-- if there are creation errors, they will show here -->
                            {!! HTML::ul($errors->all()) !!}

                            {!! Form::open(array('route' => 'storeEID', 'method'=>'POST','files'=>true)) !!}

                            <div class="form-group form-group-sm">
                                {!! Form::label('name', 'Name:') !!}
                                {!! Form::text('name', Request::old('name'), array('class' => 'form-control form-control-sm
                                input-sm', 'required')) !!}
                            </div>

                            <div class="form-group form-group-sm">
                                {!! Form::label('enterprise_id', 'EID:') !!}
                                {!! Form::text('enterprise_id', Request::old('enterprise_id'), array('class' =>
                                'form-control form-control-sm input-sm', 'required')) !!}
                            </div>

                            <div class="form-group form-group-sm">
                                {!! Form::label('schemaName', 'Schema Name:') !!}
                                {!! Form::text('schemaName', Request::old('schemaName'), array('class' => 'form-control form-control-sm
                                input-sm', 'required')) !!}
                            </div>

                            @auth()
                            <a href="{!!URL::route('eids')!!}" class="btn btn-sm btn-secondary" role="button">Cancel</a>
                            @else
                                <a href="{!!URL::previous()!!}" class="btn btn-sm btn-secondary" role="button">Back</a>
                            @endif
                            {!! Form::submit('Add', array('class' => 'btn btn-sm btn-info')) !!}

                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection