<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Query\Expression;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('users')) {
            Schema::connection('fways')->create('users', function (Blueprint $table) {
                $table->id();
                $table->string('name', 30);
                $table->string('surname', 30);
                $table->string('email', 50)->unique();
                $table->timestamp('email_verified_at')->nullable();
                $table->string('password');
                $table->unsignedBigInteger('eid_id');
                $table->rememberToken();
                $table->timestamps();
            });
            Schema::table('users', function ($table) {
                $table->foreign('eid_id')->references('id')->on(new Expression('public.eids'));
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('fways')->dropIfExists('users');
    }
}

