<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VATRep extends Model
{
    use HasFactory;

    public function __construct()
    {
        $this->connection = \Session::get('connectionName');
    }

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'vatrep';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['period', 'accom', 'disp', 'trav', 'med', 'cons', 'lab', 'xray', 'inj', 'proc', 'surg', 'misc',
        'vacc', 'merch', 'hosp', 'grom', 'num_inv', 'inv_base', 'inv_vat', 'inv_dis', 'inv_tot', 'inv_ctrl', 'rec', 'rec_vat',
        'rec_dis', 'rec_tot', 'rec_base', 'adj', 'adj_vat', 'vat_int', 'vat_isd', 'vat_ied', 'vat_rsd', 'vat_red', 'vat_asd',
        'vat_aed', 'vat_insd', 'vat_ined', 'vat_isn', 'vat_ien', 'x_dis', 'food', 'dent', 'zero_rated', 'zero_rated_dis',
        'exempt', 'exempt_dis', 'gen', 'sfee', 'sfee_vat', 'int_tot', 's_date', 'e_date', 'branch_id'];
}
