<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Patient extends Model
{
    use HasFactory;

    public function __construct()
    {
        $this->connection = \Session::get('connectionName');
    }

    public $incrementing = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['patient', 'name', 'sex', 'breed', 'colour', 'dob', 'manager', 'place', 'dead', 'next_worm',
        'reminders', 'type', 'vicious', 'medaid', 'operator', 'branch', 'queue', 'mass', 'xray', 'snapper', 'infectious',
        'hospital_howler', 'annesthetic_risk', 'last_seen', 'last_vacc', 'last_worm', 'dod', 'cause_dod', 'hospital_food',
        'active', 'takeon_date', 'last_group_1_vacc', 'next_group_1_vacc', 'spec_worm', 'r_ign_flg', 'ign_date', 'sent_date',
        'ign_reset_date', 'bounce_date', 'have_reset_vacc', 'last_seen_vet', 'pref_vet', 'takeon_user', 'blood_donor',
        'cur_branch', 'ma_detl', 'branch_id'];
}
