<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Curbatch extends Model
{
    use HasFactory;

    public function __construct()
    {
        $this->connection = \Session::get('connectionName');
    }

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'curbatch';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['batch', 'count', 'dline', 'invoice', 'ttype', 'dbat_date', 'ref', 'rep', 'patient', 'dist',
        'glacc', 'amount', 'dis_amount', 'tax_amount', 'cost', 'tax_indicator', 'reg_vendor', 'dbat_time', 'code', 'qty',
        'disc_type', 'combo', 'ivpd_acc', 'ivpd_sacc', 'ivpd_cos_acc', 'ivpd_cos_sacc', 'was_barcode', 'secs', 'disc_code',
        'disc_flag', 'disp_fee', 'disp_fee_amt', 'promo', 'combo_amt', 'combo_dis', 'combo_vat', 'combo_cost',
        'tran_date', 'printer', 'type_id', 'customer', 'branch_id'];
}
