<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\Client;
use App\Models\Code;
use App\Models\Curbatch;
use App\Models\Dompojb;
use App\Models\EID;
use App\Models\Lowsales;
use App\Models\Patient;
use App\Models\PatientType;
use App\Models\Sales;
use App\Models\Supplier;
use App\Models\Timeline;
use App\Models\Type;
use App\Models\User;
use App\Models\VATRep;
use App\Models\Vettot;
use App\Models\Vettotb;
use App\Models\Vetuser;
use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Str;

class ReportController extends Controller
{
    public function DailyStockTracker()
    {
        $warehouses = Warehouse::where('id', '>', 0)->orderBy('name', 'asc')->get();
        $types = Type::where('id', '>', 0)->orderBy('description', 'asc')->get();
        $codes = Code::where('id', '>', 0)->orderBy('description', 'asc')->get();

        return view('reports.DailyStockTracker', compact('warehouses', 'types', 'codes'));
    }
    /**
     * Ajax call to return all codes
     *
     * @return Code
     */
    public function ajaxCodes($type_id)
    {
        $codes = Code::where('type_id', '=', $type_id)->orderBy('description', 'asc')->get();
        return $codes;
    }
    public function DailyStockReport(Request $request)
    {
        if ($request->start_date > $request->end_date)
            return Redirect::route('DailyStockTracker')->withInput()->with('danger', 'Start date cannot be greater than End date');

        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::where('id', '=', $user->eid_id)->first();
        $name = $eid->schemaName;

        $warehouse = Warehouse::find($request->warehouse_id);
        $type = Type::find($request->type_id);
        $code = Code::find($request->code_id);
        $start_date = date('d/m/Y', strtotime($request->start_date));
        $end_date = date('d/m/Y', strtotime($request->end_date));
        $repDate = Carbon::now();

        $sql = ("select * from (select date(generate_series('$request->start_date', '$request->end_date', '1 day'::interval))
            monthDate) as dates left join (select quantity_on_hand,stock_date from $name.stockds where warehouse_id =
            $request->warehouse_id and type_id = $request->type_id and code_id = $request->code_id group by stock_date,
            warehouse_id, type_id, code_id, quantity_on_hand) sds on dates.monthDate = sds.stock_date
            left join (select sum(qty) as qty, ttype, invoice, customer, batch, dbat_date as sold_date, 'cur' as tab
            from $name.curbatch where ttype = '$type->type' and code = $code->code group by dbat_date, ttype, invoice,
            customer, batch) crb on dates.monthDate = crb.sold_date
            left join (select sum(qty) as qty, ttype, invoice, customer, batch, dpojb_date as sold_date, 'dom' as tab
            from $name.dompojb where ttype = '$type->type' and code = $code->code group by dpojb_date, ttype, invoice,
            customer, batch) dpj on dates.monthDate = dpj.sold_date
            left join (select sub_type, trans_type, loc_from, loc_to, adjust_qty, salesman, sup_inv, stra_date as
            sold_date from $name.stktra where type_id = $request->type_id and code_id = $request->code_id group by
            stktra.stra_date, sub_type, trans_type, loc_from, loc_to, adjust_qty, salesman, sup_inv) stk on
            dates.monthDate = stk.sold_date");
        $records = DB::select($sql);

        $detail_report = $request->detailed_report;
        $stockdRep = array();
        $adjustRecs = array();
        $str_date = null;
        $qty_sold = 0; $str_opening_qty = 0; $str_received_qty = 0; $str_adjusted_qty = 0; $str_returned_qty = 0;
        $str_closing_qty = 0;

        foreach ($records as $rec)
        {
            $dailyStockTracker = new DailyStockTracker();
            $qty_rec = 0; $qty_adj = 0; $qty_ret = 0; $closing_qty = 0; $editRec = null; $editDate = null;
            $adjust = 'N';  $transfer = 'N'; $receipt = 'N'; $return = 'N';

            if ($detail_report == 'on') {
                if ($rec->qty != null) {
                    $adjustRec = new Adjustments();
                    $d = Carbon::createFromFormat('Y-m-d', $rec->stock_date);
                    $adjustRec->adjust_date = $d->format('d/m/Y', $d);
                    if ($rec->tab == 'cur')
                        $adjustRec->adjust_rec = '-->    Current Batch: ' . $rec->qty . ' Client: ' .
                            $rec->customer . ' Invoice: ' . $rec->invoice;
                    else
                        $adjustRec->adjust_rec = '-->     Closed Batch: ' . $rec->qty . ' Client: ' . $rec->customer .
                            ' Invoice: ' . $rec->invoice . ' ' . $rec->batch;
                    array_push($adjustRecs, $adjustRec);
                }
                if ($rec->sub_type == 'TRF')
                    continue;
                if ($rec->trans_type == 'ADJ' && $rec->sub_type == 'QTY' && $rec->loc_from == 0 &&
                    $rec->loc_to != $request->warehouse_id)
                    continue;
                if ($rec->trans_type == 'ADJ' && $rec->sub_type == 'QTY' && $rec->loc_from == 0 &&
                    $rec->loc_to == $request->warehouse_id)
                    $this->editQuantities($rec, $qty_ret, $qty_rec, $qty_adj, $detail_report, $adjust, $transfer,
                        $receipt, $return);
                if ($rec->trans_type == 'REC' && $rec->sub_type == 'REC' && $rec->loc_to == $request->warehouse_id)
                    $this->editQuantities($rec, $qty_ret, $qty_rec, $qty_adj, $detail_report, $adjust, $transfer,
                        $receipt, $return);
                $editDate = $rec->sold_date;
                if ($adjust == 'Y') {
                    $editRec = '--> Stock Adjustment: ' . $rec->adjust_qty . ' User: ' . $rec->salesman;
                } elseif ($transfer == 'Y') {
                    $editRec = '-->   Stock Transfer: ' . $rec->adjust_qty . ' From: ' . $rec->loc_from .
                        ' To: ' . $rec->loc_to . ' User: ' . $rec->salesman;
                } elseif ($receipt == 'Y') {
                    $editRec = '-->    Stock Receipt: ' . $rec->adjust_qty . ' Invoice: ' . $rec->sup_inv .
                        ' User: ' . $rec->salesman;
                } elseif ($return == 'Y') {
                    $editRec = '-->     Stock Return: ' . $rec->adjust_qty . ' Client: ' . $rec->sup_inv .
                        ' User: ' . $rec->salesman;
                }
            }
            if ($editRec != null) {
                $adjustRec = new Adjustments();
                $d = Carbon::createFromFormat('Y-m-d', $editDate);
                $adjustRec->adjust_date = $d->format('d/m/Y', $d);
                $adjustRec->adjust_rec = $editRec;
                array_push($adjustRecs, $adjustRec);
            }
            $date = date('d/m/Y', strtotime($rec->stock_date));
            if ($date == $str_date)
                $qty_sold = $qty_sold + $rec->qty;
            elseif ($str_date != null) {
                $qty_sold = $qty_sold * -1;
                $closing_qty = $str_closing_qty;
                $dailyStockTracker->stock_date = $str_date;
                $dailyStockTracker->opening_qty = $str_opening_qty;
                $dailyStockTracker->sold_qty = $qty_sold;
                $dailyStockTracker->received_qty = $str_received_qty;
                $dailyStockTracker->adjusted_qty = $str_adjusted_qty;
                $dailyStockTracker->returned_qty = $str_returned_qty;
                $dailyStockTracker->closing_qty = ($str_opening_qty + $qty_sold + $str_received_qty + $str_adjusted_qty
                    + $str_returned_qty);
                array_push($stockdRep, $dailyStockTracker);
            }
            if ($str_date != $date) {
                $qty_sold = $rec->qty;
            }
            $str_date = $date;
            $str_opening_qty = $rec->quantity_on_hand;
            $str_received_qty = $qty_rec;
            $str_adjusted_qty = $qty_adj;
            $str_returned_qty = $qty_ret;
            $str_closing_qty = ($closing_qty + $rec->quantity_on_hand + $qty_sold + $qty_rec + $qty_adj + $qty_ret);
        }
        $qty_sold = $qty_sold * -1;
        $dailyStockTracker->stock_date = $str_date;
        $dailyStockTracker->opening_qty = $str_opening_qty;
        $dailyStockTracker->sold_qty = $qty_sold;
        $dailyStockTracker->received_qty = $str_received_qty;
        $dailyStockTracker->adjusted_qty = $str_adjusted_qty;
        $dailyStockTracker->returned_qty = $str_returned_qty;
        $dailyStockTracker->closing_qty = ($str_opening_qty + $qty_sold + $str_received_qty + $str_adjusted_qty
            + $str_returned_qty);
        array_push($stockdRep, $dailyStockTracker);

        return view('reports.DailyStockReport', compact('warehouse', 'type', 'code', 'start_date', 'end_date',
            'repDate', 'stockdRep', 'adjustRecs'));
    }
    public function editQuantities($stktra, &$qty_ret, &$qty_rec, &$qty_adj, $detail_report, &$adjust, &$transfer,
       &$receipt, &$return)
    {
        if ($stktra->sub_type == 'RET')
            $qty_ret = $qty_ret + $stktra->adjust_qty;
        if ($detail_report == 'on') {
            if ($stktra->trans_type == 'ADJ' && $stktra->sub_type == 'QTY' && $stktra->loc_from == 0)
                $adjust = 'Y';
            elseif ($stktra->trans_type == 'ADJ' && $stktra->sub_type == 'QTY' && $stktra->loc_from != 0)
                $transfer = 'Y';
            elseif ($stktra->trans_type == 'REC' && $stktra->sub_type == 'REC')
                $receipt = 'Y';
            elseif ($stktra->sub_type == 'RET')
                $return = 'Y';
        }
        switch ($stktra->trans_type) {
            case 'REC':
                $qty_rec = $qty_rec + $stktra->adjust_qty;
                break;
            case 'ADJ':
                $qty_adj = $qty_adj + $stktra->adjust_qty;
                break;
        }
    }
    public function searchSalesByType()
    {
        $warehouses = Warehouse::where('id', '>', 0)->orderBy('name', 'asc')->get();
        $types = Type::where('id', '>', 0)->orderBy('description', 'asc')->get();
        $suppliers = Supplier::where('id', '>', 0)->orderBy('name', 'asc')->get();

        return view('reports.SalesByType', compact('warehouses', 'types', 'suppliers'));
    }
    public function salesTypeSummary(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->end_date < $request->start_date)
            return Redirect::route('SalesByType')->withInput()->with('danger', 'Start Date cannot be greater than End Date');

        if ($request->warehouse_id == null)
            $branch = "All Branches";
        else {
            $b = Branch::where('id', '=', $request->warehouse_id)->first();
            $branch = $b->description;
        }
        if ($request->type_indicator == null) {
            if ($request->type_id == null)
                return Redirect::route("SalesByType")->withInput()
                    ->with('danger', 'If report on all stock types is not checked, stock type cannot be null');
            else {
                $t = Type::find($request->type_id);
                $type = $t->description;
            }
        } else {
            if ($request->type_id != null)
                return Redirect::route("SalesByType")->withInput()
                    ->with('danger', 'If report on all stock types is checked, stock type must be null');
            $type = "All Stock Types";
        }
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::where('id', '=', $user->eid_id)->first();
        $name = $eid->schemaName;
        DB::table($name . '.' . 'sales')->where('last_sale', '>=', $request->start_date)
            ->where('last_sale', '<=', $request->end_date)->truncate();

        if ($request->supplier_id != null) {
            $sup = Supplier::where('id', '=', $request->supplier_id)->first();
            $supplier = $sup->name;
        } else
            $supplier = null;

        if ($request->manufacturer != null) {
            $man = Supplier::where('id', '=', $request->manufacturer)->first();
            $manufacturer = $man->name;
        } else
            $manufacturer = null;

        $sDate = Carbon::createFromFormat('Y-m-d', $request->start_date);
        $start_date = $sDate->format('d/m/Y', $sDate);
        $eDate = Carbon::createFromFormat('Y-m-d', $request->end_date);
        $end_date = $eDate->format('d/m/Y', $eDate);
        $qty_tot = 0; $mass_tot = 0; $cost_tot = 0; $sales_tot = 0; $discount_tot = 0; $profit_tot = 0;

        $cType = Type::where('type', '=', 'I')->first();
        $sql = "select ttype, dbat_date, dbat_time, code, ref, branch_id, sum(amount) as amount, sum(dis_amount) as 
            dis_amount, sum(tax_amount) as tax_amount, sum(cost) as cost, sum(qty) as qty from $name.curbatch where 
            dbat_date >= '$request->start_date' and dbat_date <= '$request->end_date' and type_id = $cType->id group by 
            ttype, dbat_date, dbat_time, code, ref, branch_id";
        $curbatch = DB::select($sql);
        foreach ($curbatch as $curbat) {
            if ($curbat->ttype == 'B' or $curbat->ttype == 'D' or $curbat->ttype == 'R' or $curbat->ttype == 'Y' or
                $curbat->ttype == 'Q' or $curbat->ttype == 'A' or $curbat->ttype == 'C' or $curbat->ttype == 'P' or
                $curbat->ttype == 'O' or $curbat->ttype == 'Z' or $curbat->ttype == 'K' or $curbat->ttype == 'G')
                continue;

            if ($curbat->code == null or $curbat->code == 0)
                continue;
            if ($curbat->ttype == 'E')
                $curbat->ttype = 'M';
            $curbatType = Type::where('type', '=', $curbat->ttype)->first();
            if ($curbatType) {
                if ($request->type_id != null && $curbatType->id != $request->type_id)
                    continue;
                if ($request->warehouse_id != null && trim($curbat->branch_id) != $request->warehouse_id)
                    continue;

                if ($request->supplier_d == null) {
                    if ($request->manufacturer == null) {
                        $this->curSalesRecord($curbat, $qty_tot, $mass_tot, $cost_tot, $sales_tot, $discount_tot, $profit_tot);
                    } else {
                        $code = Code::where('code', '=', $curbat->code)
                            ->where('type_id', '=', $curbatType->type_id)->first();
                        if ($code) {
                            if ($code->manufacturer != $request->manufacturer)
                                continue;
                            $this->curSalesRecord($curbat, $qty_tot, $mass_tot, $cost_tot, $sales_tot, $discount_tot, $profit_tot);
                        }
                    }
                } else {
                    $code = Code::where('code', '=', $curbat->code)
                        ->where('type_id', '=', $curbatType->type_id)->first();
                    if ($code) {
                        if ($code->stkind == 'N')
                            continue;
                        if ($code->supplier != $request->supplier_id)
                            continue;
                        $this->curSalesRecord($curbat, $qty_tot, $mass_tot, $cost_tot, $sales_tot, $discount_tot, $profit_tot);
                    }
                }
            }
        }
        $iType = Type::where('type', '=', 'I')->first();
        $sql = "select ttype, dpojb_date, dpojb_time, code, ref, branch_id, sum(amount) as amount, sum(dis_amount) as 
            dis_amount, sum(tax_amount) as tax_amount, sum(cost) as cost, sum(qty) as qty from $name.dompojb where 
            dpojb_date >= '$request->start_date' and dpojb_date <= '$request->end_date' and type_id = $iType->id group by 
            ttype, dpojb_date, dpojb_time, code, ref, branch_id";
        $dompojb = DB::select($sql);
        foreach ($dompojb as $dompoj) {
            if ($dompoj->ttype == 'B' or $dompoj->ttype == 'D' or $dompoj->ttype == 'R' or $dompoj->ttype == 'Y' or
                $dompoj->ttype == 'Q' or $dompoj->ttype == 'A' or $dompoj->ttype == 'C' or $dompoj->ttype == 'P' or
                $dompoj->ttype == 'O' or $dompoj->ttype == 'Z' or $dompoj->ttype == 'K' or $dompoj->ttype == 'G')
                continue;
            if ($dompoj->code == null or $dompoj->code == 0)
                continue;
            if ($dompoj->ttype == 'E')
                $dompoj->ttype = 'M';

            $dompojType = Type::where('type', '=', $dompoj->ttype)->first();
            if ($dompojType) {
                if ($request->type_id != null && $dompojType->id != $request->type_id)
                    continue;
                if ($request->warehouse_id != null && trim($dompoj->branch_id) != $request->warehouse_id)
                    continue;

                if ($request->supplier_d == null) {
                    if ($request->manufacturer == null) {
                        $this->domSalesRecord($dompoj, $qty_tot, $mass_tot, $cost_tot, $sales_tot, $discount_tot, $profit_tot);
                    } else {
                        $code = Code::where('code', '=', $dompoj->code)
                            ->where('type_id', '=', $dompojType->type_id)->first();
                        if ($code) {
                            if ($code->manufacturer != $request->manufacturer)
                                continue;
                            $this->domSalesRecord($dompoj, $qty_tot, $mass_tot, $cost_tot, $sales_tot, $discount_tot, $profit_tot);
                        }
                    }
                } else {
                    $code = Code::where('code', '=', $dompoj->code)
                        ->where('type_id', '=', $dompojType->type_id)->first();
                    if ($code) {
                        if ($code->stkind == 'N')
                            continue;
                        if ($code->supplier != $request->supplier_id)
                            continue;
                        $this->domSalesRecord($dompoj, $qty_tot, $mass_tot, $cost_tot, $sales_tot, $discount_tot, $profit_tot);
                    }
                }
            }
        }
        if ($request->type_indicator == 'on') {
            $types = Type::where('id', '>', 0)->orderBy('type', 'asc')->get();
            $sql = "SELECT ref, type_id, sum(qty) as qty, sum(mass) as mass, sum(cost) as cost, sum(amount) as sales,
                    sum(discount) as discount, sum(profit) as profit FROM $name.sales where last_sale >=
                    '$request->start_date' AND last_sale <= '$request->end_date'
                    GROUP BY ref, type_id ORDER BY ref ASC ";
            $sales = DB::select($sql);

            $typeTot = array();
            foreach ($types as $type) {
                $sql = "SELECT type_id, sum(qty) as qty, sum(mass) as mass, sum(cost) as cost, sum(amount) as sales,
                    sum(discount) as discount, sum(profit) as profit FROM $name.sales where last_sale >=
                    '$request->start_date' AND last_sale <= '$request->end_date' and type_id = $type->id GROUP BY type_id";
                $recs = DB::select($sql);

                foreach ($recs as $rec) {
                    $salesTot = new SalesTotals();
                    $salesTot->id = $type->id;
                    $salesTot->description = $type->description;
                    $salesTot->qty = $rec->qty;
                    $salesTot->mass = $rec->mass;
                    $salesTot->cost = $rec->cost;
                    $salesTot->sales = $rec->sales;
                    $salesTot->discount = $rec->discount;
                    $salesTot->profit = $rec->profit;
                    array_push($typeTot, $salesTot);
                }
            }
            return view('reports.SalesReportByAll', compact('branch', 'start_date', 'end_date', 'type', 'supplier',
                'manufacturer', 'sales', 'qty_tot', 'mass_tot', 'cost_tot', 'sales_tot', 'discount_tot', 'profit_tot',
                'typeTot'));
        } else {
            $sql = "SELECT ref, sum(qty) as qty, sum(mass) as mass, sum(cost) as cost, sum(amount) as sales, sum(discount) as
            discount, sum(profit) as profit FROM $name.sales where last_sale >= '$request->start_date' AND
            last_sale <= '$request->end_date' GROUP BY ref ORDER BY ref ASC ";
            $sales = DB::select($sql);

            return view('reports.SalesReportByType', compact('branch', 'start_date', 'end_date', 'type', 'supplier',
                'manufacturer', 'sales', 'qty_tot', 'mass_tot', 'cost_tot', 'sales_tot', 'discount_tot', 'profit_tot'));
        }
    }
    public function curSalesRecord($curbatch, &$qty_tot, &$mass_tot, &$cost_tot, &$sales_tot, &$discount_tot, &$profit_tot)
    {
        $curType = Type::where('type', '=', $curbatch->ttype)->first();
        $curCode = Code::where('code', '=', $curbatch->code)->first();
        if ($curType && $curCode) {
            $contains = Str::contains($curbatch->ref, ['$']);
            if ($contains == true)
                $curbatch->ref = str_replace('$', ' ', $curbatch->ref);
            $sales = Sales::where('type_id', '=', $curType->id)
                ->where('ref', 'like', '%' . $curbatch->ref . '%')->first();
            if ($sales) {
                $sales->amount = $sales->amount + $curbatch->amount;
                $sales->discount = $sales->discount + $curbatch->dis_amount;
                $sales->cost = $sales->cost + $curbatch->cost;
                $sales->vat = $sales->vat + $curbatch->tax_amount;
                $sales->profit = $sales->profit + (($curbatch->amount + $curbatch->dis_amount) - $curbatch->cost);
                $sales->last_sale = $curbatch->dbat_date;
                if ($curType->type == 'D')
                    $sales->qty = $sales->qty + 100;
                else
                    $sales->qty = $sales->qty + $curbatch->qty;
                if ($curbatch->qty < 0)
                    $sales->no_sales = $sales->no_sales - 1;
                else
                    $sales->no_sales = $sales->no_sales + 1;
                $sales->mass = $sales->mass + ($curCode->unit_wt * $curbatch->qty);
                $sales->type_id = $curType->id;
                $sales->update();
            } else {
                $sales = new Sales();
                $sales->ref = $curbatch->ref;
                if ($curType->type == 'D')
                    $sales->qty = 100;
                else
                    $sales->qty = $curbatch->qty;
                $sales->amount = $curbatch->amount;
                $sales->discount = $curbatch->dis_amount;
                $sales->vat = $curbatch->tax_amount;
                $sales->cost = $curbatch->cost;
                $sales->profit = (($curbatch->amount + $curbatch->dis_amount) - $curbatch->cost);
                $sales->last_sale = $curbatch->dbat_date;
                if ($curbatch->qty < 0)
                    $sales->no_sales = -1;
                else
                    $sales->no_sales = 1;
                $sales->mass = $curCode->unit_wt * $curbatch->qty;
                $sales->type_id = $curType->id;
                $sales->save();
            }
            $qty_tot = $qty_tot + $sales->qty;
            $mass_tot = $mass_tot + $sales->mass;
            $cost_tot = $cost_tot + $sales->cost;
            $sales_tot = $sales_tot + $sales->amount;
            $discount_tot = $discount_tot + $sales->discount;
            $profit_tot = $profit_tot + $sales->profit;
        }
    }
    public function domSalesRecord($dompojb, &$qty_tot, &$mass_tot, &$cost_tot, &$sales_tot, &$discount_tot, &$profit_tot)
    {
        $domType = Type::where('type', '=', $dompojb->ttype)->first();
        $domCode = Code::where('code', '=', $dompojb->code)->first();
        if ($domType && $domCode) {
            $contains = Str::contains($dompojb->ref, ['$']);
            if ($contains == true)
                $dompojb->ref = str_replace('$', ' ', $dompojb->ref);
            $sales = Sales::where('type_id', '=', $domType->id)
                ->where('ref', '=', $dompojb->ref)->first();
            if ($sales) {
                $sales->amount = $sales->amount + $dompojb->amount;
                $sales->discount = $sales->discount + $dompojb->dis_amount;
                $sales->cost = $sales->cost + $dompojb->cost;
                $sales->vat = $sales->vat + $dompojb->tax_amount;
                $sales->profit = $sales->profit + (($dompojb->amount + $dompojb->dis_amount) - $dompojb->cost);
                $sales->last_sale = $dompojb->dpojb_date;
                if ($domType->type == 'D')
                    $sales->qty = $sales->qty + 100;
                else
                    $sales->qty = $sales->qty + $dompojb->qty;
                if ($dompojb->qty < 0)
                    $sales->no_sales = $sales->no_sales - 1;
                else
                    $sales->no_sales = $sales->no_sales + 1;
                $sales->mass = $sales->mass + ($domCode->unit_wt * $dompojb->qty);
                $sales->type_id = $domType->id;
                $sales->update();
            } else {
                $sales = new Sales();
                $sales->ref = $dompojb->ref;
                if ($domType->type == 'D')
                    $sales->qty = 100;
                else
                    $sales->qty = $dompojb->qty;
                $sales->amount = $dompojb->amount;
                $sales->discount = $dompojb->dis_amount;
                $sales->vat = $dompojb->tax_amount;
                $sales->cost = $dompojb->cost;
                $sales->profit = (($dompojb->amount + $dompojb->dis_amount) - $dompojb->cost);
                $sales->last_sale = $dompojb->dpojb_date;
                if ($dompojb->qty < 0)
                    $sales->no_sales = -1;
                else
                    $sales->no_sales = 1;
                $sales->mass = $domCode->unit_wt * $dompojb->qty;
                $sales->type_id = $domType->id;
                $sales->save();
            }
            $qty_tot = $qty_tot + $sales->qty;
            $mass_tot = $mass_tot + $sales->mass;
            $cost_tot = $cost_tot + $sales->cost;
            $sales_tot = $sales_tot + $sales->amount;
            $discount_tot = $discount_tot + $sales->discount;
            $profit_tot = $profit_tot + $sales->profit;
        }
    }
    public function searchLowSales()
    {
        $warehouses = Warehouse::where('id', '>', 0)->orderBy('name', 'asc')->get();
        $types = Type::where('id', '>', 0)->orderBy('description', 'asc')->get();
        $suppliers = Supplier::where('id', '>', 0)->orderBy('name', 'asc')->get();

        return view('reports.LowSales', compact('warehouses', 'types', 'suppliers'));
    }
    public function lowSalesSummary(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->type_indicator == null) {
            if ($request->type_id == null)
                return Redirect::route("LowSales")->withInput()
                    ->with('danger', 'If report on all stock types is not checked, stock type cannot be null');
            else {
                $t = Type::find($request->type_id);
                $type = $t->description;
            }
        } else {
            if ($request->type_id != null)
                return Redirect::route("LowSales")->withInput()
                    ->with('danger', 'If report on all stock types is checked, stock type must be null');
            $type = "All Stock Types";
        }
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::where('id', '=', $user->eid_id)->first();
        $name = $eid->schemaName;
        DB::table($name . '.' . 'lowsales')->truncate();

        if ($request->supplier_id != null) {
            $sup = Supplier::where('id', '=', $request->supplier_id)->first();
            $supplier = $sup->name;
        } else
            $supplier = null;

        if ($request->manufacturer != null) {
            $man = Supplier::where('id', '=', $request->manufacturer)->first();
            $manufacturer = $man->name;
        } else
            $manufacturer = null;

        $shelf_period = $request->min_shelfPeriod;
        $d = Carbon::now();
        $dateCreate = $d->format('Y-m-d', $d);
        $dateDiff = Carbon::parse($dateCreate)->subDays($shelf_period);
        $dateCompare = $dateDiff->format('Y-m-d', $dateDiff);

        $start_date = date('d/m/Y', strtotime($dateCompare));
        $end_date = date('d/m/Y', strtotime($d));
        $sales_valuation = 0;
        $cost_valuation = 0;
        $date = Carbon::now();

        if ($request->warehouse_id == null)
        {
            $branch = "All Branches";
            if ($request->type_id == null)
                $sql = ("select c.id, c.type_id, cost_price, sales_price, quantity_on_hand, stkind, c.description from 
                $name.codes c, $name.stocks s, $name.stktra sk where stra_date <= '$dateCompare' and sk.type_id = 
                s.type_id and sk.code_id = s.code_id and s.type_id = c.type_id and s.code_id = c.id group by c.id, 
                c.type_id, cost_price, sales_price, quantity_on_hand, stkind, c.description order by description asc");
            else
                $sql = ("select c.id, c.type_id, cost_price, sales_price, quantity_on_hand, stkind, c.description from 
                $name.codes c, $name.stocks s, $name.stktra sk where stra_date <= '$dateCompare' and sk.type_id = 
                s.type_id and sk.code_id = s.code_id and s.type_id = c.type_id and s.code_id = c.id and c.type_id = 
                $request->type_id group by c.id, c.type_id, cost_price, sales_price, quantity_on_hand, stkind, 
                c.description order by description asc");
        } else {
            $b = Branch::where('id', '=', $request->warehouse_id)->first();
            $branch = $b->description;
            if ($request->type_id == null)
                $sql = ("select c.id, c.type_id, cost_price, sales_price, quantity_on_hand, stkind, c.description from 
                $name.codes c, $name.stocks s, $name.stktra sk where stra_date <= '$dateCompare' and sk.type_id = 
                s.type_id and sk.code_id = s.code_id and s.type_id = c.type_id and s.code_id = c.id and warehouse_id = 
                $request->warehouse_id group by c.id, c.type_id, cost_price, sales_price, quantity_on_hand, stkind, 
                c.description order by description asc");
            else
                $sql = ("select c.id, c.type_id, cost_price, sales_price, quantity_on_hand, stkind, c.description from  
                $name.codes c, $name.stocks s, $name.stktra sk where stra_date <= '$dateCompare' and sk.type_id = 
                s.type_id and sk.code_id = s.code_id and s.type_id = c.type_id and s.code_id = c.id and c.type_id = 
                $request->type_id and  warehouse_id = $request->warehouse_id group by c.id, c.type_id, cost_price, 
                sales_price, quantity_on_hand, stkind, c.description order by description asc");
        }
        $stockCodes = DB::select($sql);
        foreach ($stockCodes as $code)
        {
            $cType = Type::find($code->type_id);
            if ($cType->type != 'J' and $cType->type != 'M' and $cType->type != 'G' and $cType->type != 'H' and $cType->type
                != 'V' and $cType->type != 'K' and $cType->type != 'L' and $cType->type != 'X' and $cType->type != 'F')
                continue;
            if ($code->stkind == 'N')
                continue;
            $contains = Str::contains($code->description, ['ZZZ']);
            if ($contains == true)
                continue;

            if ($request->supplier_id == null) {
                if ($request->manufacturer == null)
                    $this->insertLowSales($code);
                else {
                    if ($code->manufacturer != $request->manufacturer)
                        continue;
                    else
                        $this->insertLowSales($code);
                }
            } else {
                if ($code->supplier != $request->supplier_id)
                    continue;
                else
                    $this->insertLowSales($code);
            }
        }
        $lowSales = Lowsales::where('id', '>', 0)->get();
        $lowSalesSum = array();
        foreach ($lowSales as $lowSale)
        {
            $lowSalesSummary = new LowSalesSummary();
            $lowSalesSummary->id = $lowSale->id;
            $lowSalesSummary->description = $lowSale->description;
            $lowSalesSummary->qty_sold = $lowSale->sales;
            if ($lowSale->last_sale != null) {
                $ldate = Carbon::createFromFormat('Y-m-d', $lowSale->last_sale);
                $lowSalesSummary->last_sale = $ldate->format('d/m/Y', $ldate);
            } else
                $lowSalesSummary->last_sale = $lowSale->last_sale;

            $lowSalesSummary->no_sales = $lowSale->no_sales;
            if ($request->zeroQtyOnHand == "on") {
                $lowSalesSummary->cost_price = $lowSale->cost_price;
                $lowSalesSummary->sales_price = $lowSale->sales_price;
                $lowSalesSummary->on_hand = $lowSale->quantity_on_hand;
                $lowSalesSummary->sales_valuation = $lowSalesSummary->sales_price * $lowSalesSummary->on_hand;
                $lowSalesSummary->cost_valuation = $lowSalesSummary->cost_price * $lowSalesSummary->on_hand;
                array_push($lowSalesSum, $lowSalesSummary);
            } else {
                if ($lowSale->quantity_on_hand > 0.00) {
                    $lowSalesSummary->cost_price = $lowSale->cost_price;
                    $lowSalesSummary->sales_price = $lowSale->sales_price;
                    $lowSalesSummary->on_hand = $lowSale->quantity_on_hand;
                    $lowSalesSummary->sales_valuation = $lowSalesSummary->sales_price * $lowSalesSummary->on_hand;
                    $lowSalesSummary->cost_valuation = $lowSalesSummary->cost_price * $lowSalesSummary->on_hand;
                    array_push($lowSalesSum, $lowSalesSummary);
                }
            }
            $sales_valuation = $sales_valuation + $lowSalesSummary->sales_valuation;
            $cost_valuation = $cost_valuation + $lowSalesSummary->cost_valuation;
        }
        return view('reports.LowSalesReport', compact('branch', 'type', 'lowSalesSum', 'date', 'start_date', 'end_date',
            'shelf_period', 'supplier', 'manufacturer', 'sales_valuation', 'cost_valuation'));
    }
    public function insertLowSales($code)
    {
        $lowSale = new Lowsales();
        $lowSale->description = $code->description;
        $lowSale->sales = 0.0;
        $lowSale->last_sale = null;
        $lowSale->no_sales = 0;
        $lowSale->cost_price = $code->cost_price;
        $lowSale->sales_price = $code->sales_price;
        $lowSale->quantity_on_hand = $code->quantity_on_hand;
        $lowSale->type_id = $code->type_id;
        $lowSale->code_id = $code->id;
        $lowSale->save();
    }
    public function scheduledDrugs()
    {
        $warehouses = Warehouse::where('id', '>', 0)->orderBy('name', 'asc')->get();
        return view('reports.ScheduledDrugs', compact('warehouses'));
    }
    public function scheduledDrugsReport(Request $request)
    {
        if ($request->end_date < $request->start_date)
            return Redirect::route('ScheduledDrugs')->withInput()->with('danger', 'Start Date cannot be greater than End Date');

        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::where('id', '=', $user->eid_id)->first();
        $name = $eid->schemaName;

        if ($request->start_schedule < 5 or $request->end_schedule > 9)
            return Redirect::route('ScheduledDrugs')->withInput()->with('danger', 'Schedules must be from 5 to 9');

        if ($request->start_schedule > $request->end_schedule)
            return Redirect::route('ScheduledDrugs')->withInput()->with('danger', 'Start schedule cannot be greater than End schedule');

        if ($request->warehouse_id == null)
            return Redirect::route('ScheduledDrugs')->withInput()->with('danger', 'Warehouse must be selected');

        $warehouse = Warehouse::find($request->warehouse_id);
        $type = Type::where('type', '=', 'M')->first();
        $date = Carbon::now();
        $startDate = Carbon::createFromFormat('Y-m-d', $request->start_date);
        $sdate = $startDate->format('d/m/Y', $startDate);
        $endDate = Carbon::createFromFormat('Y-m-d', $request->end_date);
        $edate = $endDate->format('d/m/Y', $endDate);
        $sSchedule = $request->start_schedule;
        $eSchedule = $request->end_schedule;

        $sql = "select w.name, c.description, c.uom, c.schedule, t.type, c.code, sd.stock_date, sd.quantity_on_hand, s.client,
            s.patient, p.name, s.date_dispensed, s.qty from $name.sledger s, $name.stockds sd, $name.types t, $name.codes c,
            $name.warehouses w, $name.patients p where t.type = 'M' and c.schedule >= $request->start_schedule and
            c.schedule <= $request->end_schedule and w.id = $warehouse->id and w.id = sd.warehouse_id and sd.stock_date >=
            '$request->start_date' and sd.stock_date <= '$request->end_date' and t.id = sd.type_id and c.id = sd.code_id and
            sd.warehouse_id = s.warehouse_id and sd.type_id = s.type_id and sd.code_id = s.code_id and sd.stock_date =
            s.date_dispensed and s.patient = p.patient ORDER BY c.description, s.date_dispensed ASC";
        $sledgers = DB::select($sql);

        $scheduledDrugs = array();
        $descr = "";
        $bal = 0;
        foreach ($sledgers as $sledger) {
            $schedDrugs = new SchedDrugs();
            $contains = Str::contains($sledger->client, ['S-ADJQ', 'S-RET', 'S-REC', 'S-TRF', 'START', 'END']);
            if ($contains == true)
                $schedDrugs->qty = $sledger->qty;
            else
                $schedDrugs->qty = $sledger->qty * -1;
            $schedDrugs->description = $sledger->description;
            $schedDrugs->uom = $sledger->uom;
            $schedDrugs->schedule = $sledger->schedule;
            $schedDrugs->code = $sledger->code;
            $stkDate = Carbon::createFromFormat('Y-m-d', $sledger->stock_date);
            $schedDrugs->stock_date = $stkDate->format('d/m/Y', $stkDate);
            $schedDrugs->quantity_on_hand = $sledger->quantity_on_hand;
            $schedDrugs->customer = $sledger->client;
            $schedDrugs->patient = $sledger->patient;
            $schedDrugs->patName = $sledger->name;
            $disDate = Carbon::createFromFormat('Y-m-d', $sledger->date_dispensed);
            $schedDrugs->date_dispensed = $disDate->format('d/m/Y', $disDate);

            if ($sledger->description != $descr) {
                $schedDrugs->balance = ($schedDrugs->quantity_on_hand + $schedDrugs->qty);
                $bal = $schedDrugs->balance;
            } else {
                $schedDrugs->balance = ($bal + $schedDrugs->qty);
                $bal = $bal + $schedDrugs->qty;
            }
            array_push($scheduledDrugs, $schedDrugs);
            $descr = $sledger->description;
        }
        return view('reports.ScheduledDrugsReport', compact('scheduledDrugs', 'warehouse', 'type', 'date', 'sdate',
            'edate', 'sSchedule', 'eSchedule'));
    }
    public function VATReport()
    {
        $branches = Branch::where('id', '>', 0)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.searchVATReport', compact('branches'));
    }
    public function VATSummary(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->start_date > $request->end_date)
            return Redirect::route('VAT')->withInput()->with('danger', 'End date cannot be less than start date');

        if ($request->branch_id == null)
            $branch_name = 'All Branches';
        else {
            $branch = Branch::find($request->branch_id);
            $branch_name = $branch->description;
        }
        $start_date = Carbon::createFromFormat('Y-m-d', $request->start_date);
        $end_date = Carbon::createFromFormat('Y-m-d', $request->end_date);

        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;

        DB::table($name . '.' . 'vatrep')->truncate();

        $adjust = 0; $adj_vat = 0; $receipt = 0; $rec_vat = 0; $rec_dis = 0; $rec_ctrl = 0; $rec_tot = 0; $sfee = 0;
        $sfee_vat = 0; $accom = 0; $disp = 0; $injc = 0; $cons = 0; $sur = 0; $trav = 0; $med = 0; $vacc = 0; $xray = 0;
        $lab = 0; $proc = 0; $misc = 0; $hosp = 0; $merch = 0; $food = 0; $dent = 0; $grom = 0; $gens = 0; $x_dis = 0;
        $interest = 0; $zero_rated = 0; $zero_rated_dis = 0; $exempt = 0; $exempt_dis = 0; $num_inv = 0; $invoiced = 0;
        $inv_vat = 0; $inv_dis = 0; $invtot = 0; $ctrl_invtot = 0; $int_tot = 0; $vat_isn = 0; $vat_ien = 0;
        $diag = 0; $ctrl_diff = 0; $tr_amount = 0; $ctrl_invtot2 = 0;

        if ($request->branch_id == null or $request->branch_id == 'A') {
            // Do adjustments and receipts
            $dompojb = DB::select("select type_id, sum(amount) as amount, sum(tax_amount) as tax_amount, sum(dis_amount)
                as dis_amount from $name.dompojb where dpojb_date >= '$start_date' and dpojb_date <= '$end_date'
                GROUP BY type_id");
            $curbatch = DB::select("select type_id, sum(amount) as amount, sum(tax_amount) as tax_amount, sum(dis_amount)
                as dis_amount from $name.curbatch where dbat_date >= '$start_date' and dbat_date <= '$end_date'
                GROUP BY type_id");

            // Do receipts and invoices
            $idompojb = DB::select("select type_id, ttype, code, invoice, amount, tax_amount, dis_amount, ref from
              $name.dompojb where dpojb_date >= '$start_date' and dpojb_date <= '$end_date' ORDER BY type_id");
            $this->editInvoices($idompojb, $accom, $disp, $trav, $med, $cons, $lab, $xray, $injc, $proc, $sur, $misc,
                $vacc, $merch, $hosp, $grom, $num_inv, $invoiced, $inv_vat, $inv_dis, $invtot, $ctrl_invtot, $interest,
                $x_dis, $food, $dent, $zero_rated, $zero_rated_dis, $exempt, $exempt_dis, $gens, $sfee, $sfee_vat,
                $int_tot, $vat_isn, $vat_ien, $diag, $ctrl_diff, $tr_amount, $ctrl_invtot2);
            $icurbatch = DB::select("select type_id, ttype, code, invoice, amount, tax_amount, dis_amount, ref from
                $name.curbatch where dbat_date >= '$start_date' and dbat_date <= '$end_date' ORDER BY type_id");
            $this->editInvoices($icurbatch, $accom, $disp, $trav, $med, $cons, $lab, $xray, $injc, $proc, $sur, $misc,
                $vacc, $merch, $hosp, $grom, $num_inv, $invoiced, $inv_vat, $inv_dis, $invtot, $ctrl_invtot, $interest,
                $x_dis, $food, $dent, $zero_rated, $zero_rated_dis, $exempt, $exempt_dis, $gens, $sfee, $sfee_vat,
                $int_tot, $vat_isn, $vat_ien, $diag, $ctrl_diff, $tr_amount, $ctrl_invtot2);
        } else {
            // Do adjustments and receipts
            $dompojb = DB::select("select type_id, sum(amount) as amount, sum(tax_amount) as tax_amount, sum(dis_amount)
                as dis_amount from $name.dompojb where dpojb_date >= '$start_date' and dpojb_date <= '$end_date'
                and branch_id = cast($request->branch_id as varchar) GROUP BY type_id");
            $curbatch = DB::select("select type_id, sum(amount) as amount, sum(tax_amount) as tax_amount, sum(dis_amount)
                as dis_amount from $name.curbatch where dbat_date >= '$start_date' and dbat_date <= '$end_date'
                and branch_id = cast($request->branch_id as varchar) GROUP BY type_id");

            // Do receipts and invoices
            $idompojb = DB::select("select type_id, ttype, code, invoice, amount, tax_amount, dis_amount, ref from
                $name.dompojb where dpojb_date >= '$start_date' and dpojb_date <= '$end_date' and branch_id =
                cast($request->branch_id as varchar) ORDER BY type_id");
            $this->editInvoices($idompojb, $accom, $disp, $trav, $med, $cons, $lab, $xray, $injc, $proc, $sur, $misc,
                $vacc, $merch, $hosp, $grom, $num_inv, $invoiced, $inv_vat, $inv_dis, $invtot, $ctrl_invtot, $interest,
                $x_dis, $food, $dent, $zero_rated, $zero_rated_dis, $exempt, $exempt_dis, $gens, $sfee, $sfee_vat,
                $int_tot, $vat_isn, $vat_ien, $diag, $ctrl_diff, $tr_amount, $ctrl_invtot2);
            $icurbatch = DB::select("select type_id, ttype, code, invoice, amount, tax_amount, dis_amount, ref from
                $name.curbatch where dbat_date >= '$start_date' and dbat_date <= '$end_date' and branch_id =
                cast($request->branch_id as varchar) ORDER BY type_id");
            $this->editInvoices($icurbatch, $accom, $disp, $trav, $med, $cons, $lab, $xray, $injc, $proc, $sur, $misc,
                $vacc, $merch, $hosp, $grom, $num_inv, $invoiced, $inv_vat, $inv_dis, $invtot, $ctrl_invtot,
                $interest, $x_dis, $food, $dent, $zero_rated, $zero_rated_dis, $exempt, $exempt_dis, $gens, $sfee,
                $sfee_vat, $int_tot, $vat_isn, $vat_ien, $diag, $ctrl_diff, $tr_amount, $ctrl_invtot2);
        }
        $records = array_merge($dompojb, $curbatch);
        foreach ($records as $rec) {
            $type = Type::find($rec->type_id);
            switch ($type->type) {
                case 'A':
                    $adjust = $adjust + $rec->amount;
                    $adj_vat = $adj_vat + $rec->tax_amount;
                    break;

                case 'C':
                    $receipt = $receipt + $rec->amount;
                    $rec_vat = $rec_vat + $rec->tax_amount;
                    $rec_dis = $rec_dis + $rec->dis_amount;
                    $rec_ctrl = $rec_ctrl + $receipt + $rec_vat;
                    $rec_tot = $rec_tot + $rec_ctrl + $rec_dis;
                    break;
            }
        }
        $vatrep = new VATRep();
        $vatrep->period = 1;
        $vatrep->accom = $accom;
        $vatrep->disp = $disp;
        $vatrep->trav = $trav;
        $vatrep->med = $med;
        $vatrep->cons = $cons;
        $vatrep->lab = $lab;
        $vatrep->xray = $xray;
        $vatrep->inj = $injc;
        $vatrep->proc = $proc;
        $vatrep->surg = $sur;
        $vatrep->misc = $misc;
        $vatrep->vacc = $vacc;
        $vatrep->merch = $merch;
        $vatrep->hosp = $hosp;
        $vatrep->grom = $grom;
        $vatrep->num_inv = $num_inv;
        $vatrep->inv_base = $invoiced;
        $vatrep->inv_vat = $inv_vat;
        $vatrep->inv_dis = $inv_dis;
        $vatrep->inv_tot = $invtot;
        $vatrep->inv_ctrl = $ctrl_invtot;
        $vatrep->rec = $receipt;
        $vatrep->rec_vat = $rec_vat;
        $vatrep->rec_dis = $rec_dis;
        $vatrep->rec_tot = $rec_tot;
        $vatrep->rec_base = $rec_ctrl;
        $vatrep->adj = $adjust;
        $vatrep->adj_vat = $adj_vat;
        $vatrep->vat_int = $interest;
        $vatrep->vat_isd = 0;
        $vatrep->vat_ied = 0;
        $vatrep->vat_rsd = 0;
        $vatrep->vat_red = 0;
        $vatrep->vat_asd = 0;
        $vatrep->vat_aed = 0;
        $vatrep->vat_insd = 0;
        $vatrep->vat_ined = 0;
        $vatrep->vat_isn = $vat_isn;
        $vatrep->vat_ien = $vat_ien;
        $vatrep->x_dis = $x_dis;
        $vatrep->food = $food;
        $vatrep->dent = $dent;
        $vatrep->zero_rated = $zero_rated;
        $vatrep->zero_rated_dis = $zero_rated_dis;
        $vatrep->exempt = $exempt;
        $vatrep->exempt_dis = $exempt_dis;
        $vatrep->gen = $gens;
        $vatrep->sfee = $sfee;
        $vatrep->sfee_vat = $sfee_vat;
        $vatrep->int_tot = $int_tot;
        $vatrep->s_date = $start_date;
        $vatrep->e_date = $end_date;
        if ($request->branch_id == null or $request->branch_id == 'A')
            $vatrep->branch_id = 'A';
        else
            $vatrep->branch_id = $request->branch_id;
        $vatrep->save();

        $date = Carbon::now();
        $vatrep = VATRep::where('s_date', '>=', $request->start_date)
            ->where('e_date', '<=', $request->end_date)->get();

        $vatRepArray = array();
        foreach ($vatrep as $vat) {
            $vatReport = new VATReport();

            if ($vat->vat_asd !== 0) {
                $vatReport->adjBatch = 'Adjustment Batch : ';
                $vatReport->vatAsd = $vat->vat_asd;
                $vatReport->vatAed = $vat->vat_aed;
            }
            if ($vat->vat_rsd !== 0) {
                $vatReport->receiptBatch = 'Receipt Batch : ';
                $vatReport->vatRsd = $vat->vat_rsd;
                $vatReport->vatRed = $vat->vat_red;
            }
            if ($vat->vat_isd !== 0) {
                $vatReport->invoiceBatch = 'Invoice Batch : ';
                $vatReport->vatIsd = $vat->vat_isd;
                $vatReport->vatIed = $vat->vat_ied;
            }
            if ($vat->vat_insd !== 0) {
                $vatReport->interestBatch = 'Interest Batch : ';
                $vatReport->vatInsd = $vat->vat_insd;
                $vatReport->vatIned = $vat->vat_ined;
            }
            $divider = $vat->inv_ctrl;
            $vatReport->accom = 'Accommodation :';
            $vatReport->accom_amt = $vat->accom;
            $vatReport->accom_perc = $vat->accom / $divider * 100.00;
            $vatReport->disp = 'Dispensing :';
            $vatReport->disp_amt = $vat->disp;
            $vatReport->disp_perc = $vat->disp / $divider * 100.00;
            $vatReport->trav = 'Travelling :';
            $vatReport->trav_amt = $vat->trav;
            $vatReport->trav_perc = $vat->trav / $divider * 100.00;
            $vatReport->med = 'Medication :';
            $vatReport->med_amt = $vat->med;
            $vatReport->med_perc = $vat->med / $divider * 100.00;
            $vatReport->cons = 'Consultations Fees :';
            $vatReport->cons_amt = $vat->cons;
            $vatReport->cons_perc = $vat->cons / $divider * 100.00;
            $vatReport->lab = 'Lab Work :';
            $vatReport->lab_amt = $vat->lab;
            $vatReport->lab_perc = $vat->lab / $divider * 100.00;
            $vatReport->xray = 'X-Rays :';
            $vatReport->xray_amt = $vat->xray;
            $vatReport->xray_perc = $vat->xray / $divider * 100.00;
            $vatReport->inj = 'Injections :';
            $vatReport->inj_amt = $vat->inj;
            $vatReport->inj_perc = $vat->inj / $divider * 100.00;
            $vatReport->proc = 'Procedures :';
            $vatReport->proc_amt = $vat->proc;
            $vatReport->proc_perc = $vat->proc / $divider * 100.00;
            $vatReport->surg = 'Surcharges :';
            $vatReport->surg_amt = $vat->surg;
            $vatReport->surg_perc = $vat->surg / $divider * 100.00;
            $vatReport->vacc = 'Vaccinations :';
            $vatReport->vacc_amt = $vat->vacc;
            $vatReport->vacc_perc = $vat->vacc / $divider * 100.00;
            $vatReport->hosp = 'Hospital Stock :';
            $vatReport->hosp_amt = $vat->hosp;
            $vatReport->hosp_perc = $vat->hosp / $divider * 100.00;
            $vatReport->merch = 'Merchandise :';
            $vatReport->merch_amt = $vat->merch;
            $vatReport->merch_perc = $vat->merch / $divider * 100.00;
            $vatReport->food = 'Food :';
            $vatReport->food_amt = $vat->food;
            $vatReport->food_perc = $vat->food / $divider * 100.00;
            $vatReport->dent = 'Dentistry :';
            $vatReport->dent_amt = $vat->dent;
            $vatReport->dent_perc = $vat->dent / $divider * 100.00;
            $vatReport->grom = 'Grooming :';
            $vatReport->grom_amt = $vat->grom;
            $vatReport->grom_perc = $vat->grom / $divider * 100.00;
            $vatReport->gen = 'General Services :';
            $vatReport->gen_amt = $vat->gen;
            $vatReport->gen_perc = $vat->gen / $divider * 100.00;
            $vatReport->inv_disc = 'Invoice Discount :';
            $vatReport->inv_amt = $vat->x_dis;
            $vatReport->inv_perc = $vat->x_dis / $divider * 100.00;
            $vatReport->unknown = 'Unknown :';
            $vatReport->unknown_amt = $vat->misc;
            $vatReport->unknown_perc = $vat->misc / $divider * 100.00;
            $vatReport->totInvoiced = 'Total Invoiced :';
            $vatReport->totInvAmt = $vat->inv_ctrl;
            $net = $vat->inv_ctrl;
            $vatReport->baseInvoice = 'Base Invoice Amount :';
            $vatReport->baseInvAmt = $vat->inv_base;
            $vatReport->lessDisc = 'Less Other Invoice Discount :';
            $vatReport->lessDiscAmt = $vat->inv_dis;
            $temp_amt = $vat->inv_base + $vat->inv_dis;
            $vatReport->subTot = 'Sub Total :';
            $vatReport->subTotal = $temp_amt;
            $vatReport->addVAT = 'Add VAT on Invoices :';
            $vatReport->addVATInv = $vat->inv_vat;
            $temp_amt = $temp_amt + $vat->inv_vat;
            $vatReport->contrTot = 'Control Total :';
            $vatReport->contrTotal = $temp_amt;
            $vatReport->adjust = 'Adjustments :';
            $vatReport->adjustment = $vat->adj;
            $vatReport->adjustVAT = 'Adjustments V.A.T :';
            $vatReport->adjustmentVAT = $vat->adj_vat;
            $temp_amt = $temp_amt + $vat->adj_vat + $vat->adj;
            $vatReport->invoiceTot = 'Invoice Total :';
            $vatReport->invoiceTotal = $temp_amt;
            $vatReport->zeroRating = 'Zero Rating Amount :';
            $vatReport->zeroRatingAmt = $vat->zero_rated;
            $vatReport->zeroDiscount = 'Zero Rating Discount :';
            $vatReport->zeroRatingDiscount = $vat->zero_rated_dis;
            $temp_amt1 = $vat->zero_rated + $vat->zero_rated_dis;
            $vatReport->zeroTotal = 'Zero Rating Total :';
            $vatReport->zeroRatingTotal = $temp_amt1;
            $vatReport->exempt = 'Exempt Amount :';
            $vatReport->exemptAmount = $vat->exempt;
            $vatReport->exemptDiscount = 'Exempt Amount Discount :';
            $vatReport->exemptAmtDiscount = $vat->exempt_dis;
            $temp_amt2 = $vat->exempt = $vat->exempt_dis;
            $vatReport->exemptTotal = 'Exempt Amount Total :';
            $vatReport->exemptAmtTotal = $temp_amt2;
            $vatReport->receiptSummary = 'RECEIPT SUMMARY';
            $vatReport->receipts = 'Total Receipts :';
            $vatReport->totalReceipts = $vat->rec_tot;
            $net = $net + $vat->rec_tot;
            $vatReport->lessDiscount = 'Less Receipt Discount :';
            $vatReport->lessReceiptDisc = $vat->rec_dis;
            $temp_amt = $vat->rec_tot + $vat->rec_dis;
            $vatReport->sub = 'Sub Total :';
            $vatReport->subTotal2 = $temp_amt;
            $vatReport->lessVAT = 'Less VAT Recovered :';
            $vatReport->lessVATRecover = $vat->rec_vat;
            $vatReport->actual = 'Actual Receipts :';
            $vatReport->actualReceipts = $vat->rec;
            $vatReport->adjustSummary = 'ADJUSTMENT SUMMARY';
            $vatReport->adjustments = 'Adjustments :';
            $vatReport->adjustSum = $vat->adj;
            $vatReport->VATAdjustments = 'VAT Adjustments';
            $vatReport->VATAdjust = $vat->adj_vat;
            $tot_adj = $vat->adj + $vat->adj_vat;
            $vatReport->totAdjust = 'Total Adjustments';
            $vatReport->totalAdjustments = $tot_adj;
            $net = $net - $tot_adj;
            $vatReport->interestSummary = 'INTEREST SUMMARY';
            $vatReport->interest = 'Interest Charged :';
            $vatReport->interestCharged = $vat->vat_int;
            $vatReport->accounting = 'Accounting Fee :';
            $vatReport->accountingFee = $vat->sfee;
            $vatReport->VATAccounting = 'VAT on Accounting Fee :';
            $vatReport->VATAccountingFee = $vat->sfee_vat;
            $vatReport->totCharges = 'Total Charges :';
            $vatReport->totalCharges = $vat->int_tot;
            $net = $net + $vat->int_tot;
            $vatReport->netDebtors = 'Net Debtors Change :';
            $vatReport->netDebtorsChange = $net;
            array_push($vatRepArray, $vatReport);
        }
        return view('reports.VATReport', compact('vatRepArray', 'eid', 'start_date', 'end_date', 'date', 'branch_name'));
    }
    public function editInvoices($transaction, &$accom, &$disp, &$trav, &$med, &$cons, &$lab, &$xray, &$injc,
        &$proc, &$sur, &$misc, &$vacc, &$merch, &$hosp, &$grom, &$num_inv, &$invoiced, &$inv_vat, &$inv_dis,
        &$invtot, &$ctrl_invtot, &$interest, &$x_dis, &$food, &$dent, &$zero_rated, &$zero_rated_dis, &$exempt,
        &$exempt_dis, &$gens, &$sfee, &$sfee_vat, &$int_tot, &$vat_isn, &$vat_ien, &$diag, &$ctrl_diff, &$tr_amount,
        &$ctrl_invtot2)
    {
        foreach ($transaction as $tran)
        {
            $vat_isn = $tran->invoice;
            $num_inv = 1;
            $ctrl_invtot = 0;
            $ctrl_invtot2 = 0;
            $ctrl_diff = 0;
            $type = Type::find($tran->type_id);
            if ($type->type == 'S') {
                $int_tot = $int_tot + $tran->amount + $tran->tax_amount;
                $contains = Str::contains($tran->ref, ['Inter', 'Rente']);
                $beginsWith = Str::startsWith($tran->invoice, 'I');
                if ($contains == true or $beginsWith == true)
                    $interest = $interest + $tran->amount;

                $contains2 = Str::contains($tran->ref, ['Account', 'Renken', 'Service']);
                $beginsWith2 = Str::startsWith($tran->invoice, 'A');
                if ($contains2 == true or $beginsWith2 == true) {
                    $sfee = $sfee + $tran->amount;
                    $sfee_vat = $sfee_vat + $tran->tax_amount;
                }
                continue;
            }
            if ($type->type == 'I') {
                $vat_ien = $tran->invoice;

                $tr_amount = $tran->amount + $tran->tax_amount + $tran->dis_amount;
                if ($tran->tax_amount == 0) {
                    $tType = Type::where('type', '=', $tran->ttype)->first();
                    if ($tType) {
                        $code = Code::where('type_id', '=', $tType->id)
                            ->where('code', '=', $tran->code)->first();
                        if ($code) {
                            if ($code->tax_indicator != 0) {
                                if ($tran->amount + $tran->dis_amount != 0) {
                                    $exempt = $exempt + $tran->amount;
                                    $exempt_dis = $exempt_dis + $tran->dis_amount;
                                }
                                $zero_rated = $zero_rated + $tran->amount;
                                $zero_rated_dis = $zero_rated_dis + $tran->dis_amount;
                            }
                        } else {
                            if ($tran->amount + $tran->dis_amount != 0) {
                                $exempt = $exempt + $tran->amount;
                                $exempt_dis = $exempt_dis + $tran->dis_amount;
                            }
                        }
                    }
                }
                switch ($tran->ttype) {
                    case 'A':
                        $accom = $accom + $tr_amount;
                        break;
                    case 'E':
                        $disp = $disp + $tr_amount;
                        break;
                    case 'I':
                        $injc = $injc + $tr_amount;
                        break;
                    case 'C':
                        $cons = $cons + $tr_amount;
                        break;
                    case 'S':
                        $sur = $sur + $tr_amount;
                        break;
                    case 'T':
                        $trav = $trav + $tr_amount;
                        break;
                    case 'M':
                        $med = $med + $tr_amount;
                        break;
                    case 'V':
                        $vacc = $vacc + $tr_amount;
                        break;
                    case 'X':
                        $xray = $xray + $tr_amount;
                        break;
                    case 'L':
                        $lab = $lab + $tr_amount;
                        break;
                    case 'P':
                        $proc = $proc + $tr_amount;
                        break;
                    case 'D':
                        $diag = $diag + $tr_amount;
                        break;
                    case 'H':
                        $hosp = $hosp + $tr_amount;
                        break;
                    case 'J':
                        $merch = $merch + $tr_amount;
                        break;
                    case 'F':
                        $food = $food + $tr_amount;
                        break;
                    case 'O':
                        $dent = $dent + $tr_amount;
                        break;
                    case 'K':
                        $grom = $grom + $tr_amount;
                        break;
                    case 'R':
                        $x_dis = $x_dis + $tr_amount;
                        break;
                    case 'G':
                        $gens = $gens + $tr_amount;
                        break;
                    case '':
                        if (strpos($tran->ref, 'BALANCE FO') == true) {
                            $tr_amount = 0;
                            $misc = $misc + $tr_amount;
                            break;
                        }
                }
                $invoiced = $invoiced + $tran->amount;
                $inv_vat = $inv_vat + $tran->tax_amount;
                $inv_dis = $inv_dis + $tran->dis_amount;
            }
        }
        $ctrl_invtot = $accom + $disp + $injc + $cons + $sur + $trav + $proc;
        $ctrl_invtot = ($ctrl_invtot + $med + $vacc + $xray + $lab + $diag + $misc + $merch + $hosp + $x_dis + $food +
            $dent + $grom + $gens);
        $invtot = $invoiced + $inv_dis;
        $ctrl_invtot2 = $ctrl_invtot + $inv_vat;
        $ctrl_diff = $ctrl_invtot - $ctrl_invtot2;
    }
    public function UserSales()
    {
        $reps = Vetuser::where('id', '>', 0)->orderBy('user_name', 'asc')->get();
        $branches = Branch::where('id', '>', 0)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.UserSales', compact('reps', 'branches'));
    }
    public function UserSalesReport(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->end_date < $request->start_date)
            return Redirect::route('UserSales')->withInput()->with('danger', 'End Date cannot be less than Start Date');

        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;

        $profitability = 'User Profitability Report For Period : ';
        if ($request->include_adjustment == 'on')
            $report = 'Report Includes Adjustments';
        else
            $report = 'Report Excludes Adjustments';

        $start_date = date('d/m/Y', strtotime($request->start_date));
        $end_date = date('d/m/Y', strtotime($request->end_date));

        if ($request->branch_id == null)
            $branches = Branch::where('id', '!=', null)
                ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();
        else
            $branches = Branch::where('id', '=', $request->branch_id)->get();

        DB::table($name . '.' . 'vettot')->truncate();

        $type = Type::where('type', '=', 'I')->first();
        $branchArray = array();
        $vetArray = array();
        $salesReport = array();
        $salesBranchReport = array();
        $grand_amt = 0; $grand_discount = 0; $grand_cost = 0; $grand_gross = 0; $grand_adjust = 0;
        $grand_net = 0; $grand_vat = 0;
        $types = Type::where('id', '>', 0)->orderBy('description', 'ASC')->get();
        foreach ($branches as $branch) {
            $branch_amt = 0; $branch_discount = 0; $branch_cost = 0; $branch_gross = 0; $branch_adjust = 0;
            $branch_net = 0; $branch_vat = 0; $rep = null;
            if ($request->user_code !== null)
                $dompojb = Dompojb::where('dpojb_date', '>=', $request->start_date)
                    ->where('dpojb_date', '<=', $request->end_date)
                    ->where('rep', '=', $request->user_code)
                    ->where('branch_id', '=', $branch->id)
                    ->where('type_id', '=', $type->id)->get();
            else
                $dompojb = Dompojb::where('dpojb_date', '>=', $request->start_date)
                    ->where('dpojb_date', '<=', $request->end_date)
                    ->where('branch_id', '=', $branch->id)
                    ->where('type_id', '=', $type->id)->orderBy('rep', 'asc')->get();
            $vetUsers = array();
            foreach ($dompojb as $dompoj) {
                $contains = Str::contains($dompoj->ref, ['PP DISC', 'TB AF']);
                if ($contains == true)
                    $dompoj->ttype = '1';
                $dType = Type::where('type', '=', $dompoj->ttype)->first();
                if ($dType) {
                    $vettot = Vettot::where('sdate', '>=', $request->start_date)
                        ->where('edate', '<=', $request->end_date)
                        ->where('rep', '=', $dompoj->rep)
                        ->where('type_id', '=', $dType->id)->first();

                    if ($dompoj->rep != $rep)
                        array_push($vetUsers, $dompoj->rep);

                    $rep = $dompoj->rep;
                    $updateOnly = 'N';
                    $amount = $dompoj->amount;
                    $discount = $dompoj->dis_amount;
                    $cost = $dompoj->cost;
                    $vat = $dompoj->tax_amount;
                    $profit = (($dompoj->amount + $dompoj->dis_amount) - $dompoj->cost);
                    $adj = 0;
                    $upd_id = 0;

                    if ($vettot) {
                        $updateOnly = 'Y';
                        $upd_id = $vettot->id;
                    }
                    $str_id = $dType->id;
                    $this->storeVettot($dompoj->rep, $upd_id, $str_id, $amount, $discount, $cost, $vat, $profit,
                        $adj, $request->start_date, $request->end_date, $updateOnly);
                }
            }
            $curbatch = Curbatch::where('dbat_date', '>=', $request->start_date)
                ->where('dbat_date', '<=', $request->end_date)
                ->where('type_id', '=', $type->id)->get();

            if ($curbatch) {
                foreach ($curbatch as $curb) {
                    if (($request->branch_id != null or $request->branch_id != 'A') and $curb->branch_id != $request->branch_id)
                        continue;
                    if ($request->user_code != null and $curb->rep != $request->user_code)
                        continue;
                    $contains = Str::contains($curb->ref, ['PP DISC', 'TB AF']);
                    if ($contains == true)
                        $curb->ttype = '1';

                    $cType = Type::where('type', '=', $curb->ttype)->first();
                    if ($cType) {
                        $vettot = Vettot::where('sdate', '>=', $request->start_date)
                            ->where('edate', '<=', $request->end_date)
                            ->where('rep', '=', $curb->rep)
                            ->where('type_id', '=', $cType->id)->first();

                        $updateOnly = 'N';
                        $amount = $curb->amount;
                        $discount = $curb->dis_amount;
                        $cost = $curb->cost;
                        $vat = $curb->tax_amount;
                        $profit = (($curb->amount + $curb->dis_amount) - $curb->cost);
                        $adj = 0;
                        $upd_id = 0;

                        if ($vettot) {
                            $updateOnly = 'Y';
                            $upd_id = $vettot->id;
                        }
                        $str_id = $cType->id;
                        $this->storeVettot($curb->rep, $upd_id, $str_id, $amount, $discount, $cost, $vat, $profit,
                            $adj, $request->start_date, $request->end_date, $updateOnly);
                    }
                }
            }
            if ($request->include_adjustment == 'on') {
                $aType = Type::where('type', '=', "A")->first();
                $curbatch = Curbatch::where('dbat_date', '>=', $request->start_date)
                    ->where('dbat_date', '<=', $request->end_date)
                    ->where('type_id', '=', $aType->id)->count();
                if ($curbatch > 0) {
                    $curbatch = Curbatch::where('dbat_date', '>=', $request->start_date)
                        ->where('dbat_date', '<=', $request->end_date)
                        ->where('type_id', '=', $aType->id)->get();
                    foreach ($curbatch as $curb) {
                        if ($request->branch_id != null and $curb->branch_id != $request->branch_id)
                            continue;
                        if ($request->user_code != null and $curb->rep != $request->user_code)
                            continue;
                        $contains = Str::contains($curb->ref, ['PP DISC', 'TB AF']);
                        if ($contains == true)
                            $curb->ttype = '1';
                        if (strlen($curb->ttype) > 1)
                            continue;

                        $aType = Type::where('type', '=', $curb->ttype)->first();
                        if ($aType) {
                            $vettot = Vettot::where('sdate', '>=', $request->start_date)
                                ->where('edate', '<=', $request->end_date)
                                ->where('rep', '=', $curb->rep)
                                ->where('type_id', '=', $aType->id)->first();
                            $updateOnly = 'N';
                            $upd_id = 0;

                            if ($vettot) {
                                $vettot->vat = $vettot->vat + $curb->tax_amount;
                                $vettot->adj = $vettot->adj + $curb->amount;
                                $vettot->update();
                            } else {
                                $amount = 0;
                                $discount = 0;
                                $cost = 0;
                                $vat = $curb->tax_amount;
                                $profit = 0;
                                $adj = $curb->amount;
                                $str_id = $aType->id;
                                $this->storeVettot($curb->rep, $upd_id, $str_id, $amount, $discount, $cost, $vat,
                                    $profit, $adj, $request->start_date, $request->end_date, $updateOnly);
                            }
                        }
                    }
                } else {
                    $dompojb = Dompojb::where('dpojb_date', '>=', $request->start_date)
                        ->where('dpojb_date', '<=', $request->end_date)
                        ->where('type_id', '=', $aType->id)->get();

                    foreach ($dompojb as $dompoj) {
                        if ($request->branch_id != null and $dompoj->branch_id != $request->branch_id)
                            continue;
                        if ($request->user_code != null and $dompoj->rep != $request->user_code)
                            continue;
                        $contains = Str::contains($dompoj->ref, ['PP DISC', 'TB AF']);
                        if ($contains == true)
                            $dompoj->ttype = '1';
                        if (strlen($dompoj->ttype) > 1)
                            continue;

                        $aType = Type::where('type', '=', $dompoj->ttype)->first();
                        if ($aType) {
                            $vettot = Vettot::where('sdate', '>=', $request->start_date)
                                ->where('edate', '<=', $request->end_date)
                                ->where('rep', '=', $dompoj->rep)
                                ->where('type_id', '=', $aType->id)->first();
                            $updateOnly = 'N';
                            $upd_id = 0;

                            if ($vettot) {
                                $vettot->vat = $vettot->vat + $dompoj->tax_amount;
                                $vettot->adj = $vettot->adj + $dompoj->amount;
                                $vettot->update();
                            } else {
                                $amount = 0;
                                $discount = 0;
                                $cost = 0;
                                $vat = $dompoj->tax_amount;
                                $profit = 0;
                                $str_id = $aType->id;
                                $adj = $dompoj->amount;
                                $this->storeVettot($dompoj->rep, $upd_id, $str_id, $amount, $discount, $cost, $vat,
                                    $profit, $adj, $request->start_date, $request->end_date, $updateOnly);
                            }
                        }
                    }
                }
            }
            foreach ($vetUsers as $vetUser) {
                $vet_amt = 0; $vet_discount = 0; $vet_cost = 0; $vet_gross = 0; $vet_adjust = 0; $vet_net = 0;
                $vet_vat = 0;
                foreach ($types as $type) {
                    $salesRep = new SalesReport();
                    $salesRep->type = $type->description;
                    $salesRep->vet = $vetUser;
                    $salesRep->amount = Vettot::where('type_id', '=', $type->id)
                        ->where('rep', '=', $vetUser)
                        ->where('sdate', '>=', $request->start_date)
                        ->where('edate', '<=', $request->end_date)->sum('amount');
                    $salesRep->discount = Vettot::where('type_id', '=', $type->id)
                        ->where('rep', '=', $vetUser)
                        ->where('sdate', '>=', $request->start_date)
                        ->where('edate', '<=', $request->end_date)->sum('discount');
                    $salesRep->cost = Vettot::where('type_id', '=', $type->id)
                        ->where('rep', '=', $vetUser)
                        ->where('sdate', '>=', $request->start_date)
                        ->where('edate', '<=', $request->end_date)->sum('cost');
                    $salesRep->gross = Vettot::where('type_id', '=', $type->id)
                        ->where('rep', '=', $vetUser)
                        ->where('sdate', '>=', $request->start_date)
                        ->where('edate', '<=', $request->end_date)->sum('profit');
                    $salesRep->adjust = Vettot::where('type_id', '=', $type->id)
                        ->where('rep', '=', $vetUser)
                        ->where('sdate', '>=', $request->start_date)
                        ->where('edate', '<=', $request->end_date)->sum('adj');
                    $salesRep->VAT = Vettot::where('type_id', '=', $type->id)
                        ->where('rep', '=', $vetUser)
                        ->where('sdate', '>=', $request->start_date)
                        ->where('edate', '<=', $request->end_date)->sum('vat');
                    $salesRep->net = $salesRep->gross + $salesRep->adjust;
                    array_push($salesReport, $salesRep);

                    $vet_amt = $vet_amt + $salesRep->amount;
                    $vet_discount = $vet_discount + $salesRep->discount;
                    $vet_cost = $vet_cost + $salesRep->cost;
                    $vet_gross = $vet_gross + $salesRep->gross;
                    $vet_adjust = $vet_adjust + $salesRep->adjust;
                    $vet_net = $vet_net + $salesRep->net;
                    $vet_vat = $vet_vat + $salesRep->VAT;
                }
                $vetTotals = new VetTotals();
                $vetTotals->branch_id = $branch->id;
                $vetTotals->vet_code = $vetUser;
                $vet = Vetuser::where('user_code', '=', $vetUser)->first();
                if ($vet)
                    $vetTotals->vet_name = $vet->user_name;
                else
                    $vetTotals->vet_name = $vetUser;
                $vetTotals->vet_amt = $vet_amt;
                $vetTotals->vet_discount = $vet_discount;
                $vetTotals->vet_cost = $vet_cost;
                $vetTotals->vet_gross = $vet_gross;
                $vetTotals->vet_adjust = $vet_adjust;
                $vetTotals->vet_net = $vet_net;
                $vetTotals->vet_vat = $vet_vat;
                array_push($vetArray, $vetTotals);
                $branch_amt = $branch_amt + $vet_amt;
                $branch_discount = $branch_discount + $vet_discount;
                $branch_cost = $branch_cost + $vet_cost;
                $branch_gross = $branch_gross + $vet_gross;
                $branch_adjust = $branch_adjust + $vet_adjust;
                $branch_net = $branch_net + $vet_net;
                $branch_vat = $branch_vat + $vet_vat;
            }
            $branchTotals = new BranchTotals();
            $branchTotals->branch_id = $branch->id;
            $branchTotals->branch_name = $branch->description;
            $branchTotals->branch_amt = $branch_amt;
            $branchTotals->branch_discount = $branch_discount;
            $branchTotals->branch_cost = $branch_cost;
            $branchTotals->branch_gross = $branch_gross;
            $branchTotals->branch_adjust = $branch_adjust;
            $branchTotals->branch_net = $branch_net;
            $branchTotals->branch_vat = $branch_vat;
            array_push($branchArray, $branchTotals);
            $grand_amt = $grand_amt + $branch_amt;
            $grand_discount = $grand_discount + $branch_discount;
            $grand_cost = $grand_cost + $branch_cost;
            $grand_gross = $grand_gross + $branch_gross;
            $grand_adjust = $grand_adjust + $branch_adjust;
            $grand_net = $grand_net + $branch_net;
            $grand_vat = $grand_vat + $branch_vat;
        }
        $date = Carbon::now();
        foreach ($types as $type) {
            $salesBrRep = new SalesBranchRep();
            $salesBrRep->type = $type->description;
            $salesBrRep->amount = Vettot::where('type_id', '=', $type->id)
                ->where('sdate', '>=', $request->start_date)
                ->where('edate', '<=', $request->end_date)->sum('amount');
            $salesBrRep->discount = Vettot::where('type_id', '=', $type->id)
                ->where('sdate', '>=', $request->start_date)
                ->where('edate', '<=', $request->end_date)->sum('discount');
            $salesBrRep->cost = Vettot::where('type_id', '=', $type->id)
                ->where('sdate', '>=', $request->start_date)
                ->where('edate', '<=', $request->end_date)->sum('cost');
            $salesBrRep->gross = Vettot::where('type_id', '=', $type->id)
                ->where('sdate', '>=', $request->start_date)
                ->where('edate', '<=', $request->end_date)->sum('profit');
            $salesBrRep->adjust = Vettot::where('type_id', '=', $type->id)
                ->where('sdate', '>=', $request->start_date)
                ->where('edate', '<=', $request->end_date)->sum('adj');
            $salesBrRep->net = $salesBrRep->gross + $salesBrRep->adjust;
            array_push($salesBranchReport, $salesBrRep);
        }
        return view('reports.UserSalesReport', compact('profitability', 'start_date', 'end_date', 'report', 'date',
            'salesReport', 'vetArray', 'branchArray', 'grand_amt', 'grand_discount', 'grand_cost', 'grand_gross',
            'grand_adjust', 'grand_net', 'grand_vat', 'salesBranchReport'));
    }
    public function storeVettot($rep, $upd_id, $str_id, $amount, $discount, $cost, $vat, $profit, $adj, $sdate,
        $edate, $updateOnly)
    {
        if ($updateOnly == 'Y') {
            $vettot = Vettot::find($upd_id);
            $vettot->amount = $vettot->amount + $amount;
            $vettot->discount = $vettot->discount + $discount;
            $vettot->cost = $vettot->cost + $cost;
            $vettot->vat = $vettot->vat + $vat;
            $vettot->profit = $vettot->profit + $profit;
            $vettot->update();
        } else {
            $vettot = new Vettot();
            $date = Carbon::now();
            $vettot->rep = $rep;
            $vettot->amount = $amount;
            $vettot->discount = $discount;
            $vettot->sdate = $sdate;
            $vettot->stime = $date->format('H:m:s');
            $vettot->edate = $edate;
            $vettot->etime = $date->format('H:m:s');
            $vettot->vat = $vat;
            $vettot->cost = $cost;
            $vettot->profit = $profit;
            $vettot->adj = $adj;
            $vettot->type_id = $str_id;
            $vettot->save();
        }
    }
    public function branchGrossProfit()
    {
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.BranchGrossProfit', compact('branches'));
    }
    public function branchGrossReport(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->end_date < $request->start_date)
            return Redirect::route('BranchGrossProfit')->withInput()->with('danger', 'End Date cannot be less than Start Date');

        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;

        $start_date = date('d/m/Y', strtotime($request->start_date));
        $end_date = date('d/m/Y', strtotime($request->end_date));

        if ($request->branch_id == null)
            $branches = Branch::where('id', '!=', null)
                ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();
        else
            $branches = Branch::where('id', '=', $request->branch_id)->get();

        DB::table($name . '.' . 'vettotb')->truncate();

        $iType = Type::where('type', '=', 'I')->first();
        $branchArray = array();
        $salesReport = array();
        $salesBranchReport = array();
        $grand_amt = 0; $grand_cost = 0; $grand_profit = 0;
        $types = Type::where('id', '>', 0)->orderBy('description', 'ASC')->get();
        foreach ($branches as $branch) {
            $branch_amt = 0; $branch_cost = 0; $branch_profit = 0;
            $dompojb = Dompojb::where('dpojb_date', '>=', $request->start_date)
                ->where('dpojb_date', '<=', $request->end_date)
                ->where('type_id', '=', $iType->id)
                ->where('branch_id', '=', $branch->id)->get();
            foreach ($dompojb as $dompoj) {
                if ($dompoj->ttype == 'R')
                    continue;
                $contains = Str::contains($dompoj->ref, ['PP DISC', 'TB AF']);
                if ($contains == true)
                    $dompoj->ttype = '1';

                $dType = Type::where('type', '=', $dompoj->ttype)->first();
                if ($dType) {
                    $vettotb = Vettotb::where('sdate', '>=', $request->start_date)
                        ->where('edate', '<=', $request->end_date)
                        ->where('branch_id', '=', $branch->id)
                        ->where('type_id', '=', $dType->id)->first();

                    $updateOnly = 'N';
                    $amount = $dompoj->amount;
                    $discount = $dompoj->dis_amount;
                    $cost = $dompoj->cost;
                    $vat = $dompoj->tax_amount;
                    $upd_id = 0;

                    if ($vettotb) {
                        $updateOnly = 'Y';
                        $upd_id = $vettotb->id;
                    }
                    $str_id = $dType->id;
                    $this->storeVettotb($upd_id, $str_id, $amount, $discount, $cost, $vat, $dompoj->branch_id,
                        $request->start_date, $request->end_date, $updateOnly);
                }
            }
            $curbatch = Curbatch::where('dbat_date', '>=', $request->start_date)
                ->where('dbat_date', '<=', $request->end_date)
                ->where('type_id', '=', $iType->id)
                ->where('branch_id', '=', $branch->id)->get();
            foreach ($curbatch as $curb) {
                if ($dompoj->ttype == 'R')
                    continue;
                $contains = Str::contains($curb->ref, ['PP DISC', 'TB AF']);
                if ($contains == true)
                    $curb->ttype = '1';

                $cType = Type::where('type', '=', $curb->ttype)->first();
                if ($cType) {
                    $vettotb = Vettotb::where('sdate', '>=', $request->start_date)
                        ->where('edate', '<=', $request->end_date)
                        ->where('branch_id', '=', $branch->id)
                        ->where('type_id', '=', $cType->id)->first();

                    $updateOnly = 'N';
                    $amount = $curb->amount;
                    $discount = $curb->dis_amount;
                    $cost = $curb->cost;
                    $vat = $curb->tax_amount;
                    $upd_id = 0;

                    if ($vettotb) {
                        $updateOnly = 'Y';
                        $upd_id = $vettotb->id;
                    }
                    $str_id = $cType->id;
                    $this->storeVettotb($upd_id, $str_id, $amount, $discount, $cost, $vat, $curb->branch_id,
                        $request->start_date, $request->end_date, $updateOnly);
                }
            }
            foreach ($types as $type) {
                if ($type->type == 'R')
                    continue;
                $salesRep = new SalesReport();
                $salesRep->vet = $branch->id;
                $salesRep->type = $type->description;
                $salesRep->amount = Vettotb::where('type_id', '=', $type->id)
                    ->where('branch_id', '=', $branch->id)
                    ->where('sdate', '>=', $request->start_date)
                    ->where('edate', '<=', $request->end_date)->sum('amount');
                $salesRep->discount = Vettotb::where('type_id', '=', $type->id)
                    ->where('branch_id', '=', $branch->id)
                    ->where('sdate', '>=', $request->start_date)
                    ->where('edate', '<=', $request->end_date)->sum('discount');
                $salesRep->cost = Vettotb::where('type_id', '=', $type->id)
                    ->where('branch_id', '=', $branch->id)
                    ->where('sdate', '>=', $request->start_date)
                    ->where('edate', '<=', $request->end_date)->sum('cost');
                $salesRep->gross = Vettotb::where('type_id', '=', $type->id)
                    ->where('branch_id', '=', $branch->id)
                    ->where('sdate', '>=', $request->start_date)
                    ->where('edate', '<=', $request->end_date)->sum('profit');
                $salesRep->adjust = Vettotb::where('type_id', '=', $type->id)
                    ->where('branch_id', '=', $branch->id)
                    ->where('sdate', '>=', $request->start_date)
                    ->where('edate', '<=', $request->end_date)->sum('adj');
                $salesRep->net = Vettotb::where('type_id', '=', $type->id)
                    ->where('branch_id', '=', $branch->id)
                    ->where('sdate', '>=', $request->start_date)
                    ->where('edate', '<=', $request->end_date)->sum('profit');
                $salesRep->VAT = Vettotb::where('type_id', '=', $type->id)
                    ->where('branch_id', '=', $branch->id)
                    ->where('sdate', '>=', $request->start_date)
                    ->where('edate', '<=', $request->end_date)->sum('vat');
                array_push($salesReport, $salesRep);

                $branch_amt = $branch_amt + $salesRep->amount;
                $branch_cost = $branch_cost + $salesRep->cost;
                $branch_profit = $branch_profit + $salesRep->gross;
            }
            $branchTotals = new BranchTotals();
            $branchTotals->branch_id = $branch->id;
            $branchTotals->branch_name = $branch->description;
            $branchTotals->branch_amt = $branch_amt;
            $branchTotals->branch_cost = $branch_cost;
            $branchTotals->branch_gross = $branch_profit;
            array_push($branchArray, $branchTotals);
            $grand_amt = $grand_amt + $branch_amt;
            $grand_cost = $grand_cost + $branch_cost;
            $grand_profit = $grand_profit + $branch_profit;
        }
        $date = Carbon::now();
        foreach ($types as $type) {
            if ($type->type == 'R')
                continue;
            $salesBrRep = new SalesBranchRep();
            $salesBrRep->type = $type->description;
            $salesBrRep->amount = Vettotb::where('type_id', '=', $type->id)
                ->where('sdate', '>=', $request->start_date)
                ->where('edate', '<=', $request->end_date)->sum('amount');
            $salesBrRep->discount = Vettotb::where('type_id', '=', $type->id)
                ->where('sdate', '>=', $request->start_date)
                ->where('edate', '<=', $request->end_date)->sum('discount');
            $salesBrRep->cost = Vettotb::where('type_id', '=', $type->id)
                ->where('sdate', '>=', $request->start_date)
                ->where('edate', '<=', $request->end_date)->sum('cost');
            $salesBrRep->gross = Vettotb::where('type_id', '=', $type->id)
                ->where('sdate', '>=', $request->start_date)
                ->where('edate', '<=', $request->end_date)->sum('profit');
            $salesBrRep->adjust = Vettotb::where('type_id', '=', $type->id)
                ->where('sdate', '>=', $request->start_date)
                ->where('edate', '<=', $request->end_date)->sum('adj');
            $salesBrRep->net = Vettotb::where('type_id', '=', $type->id)
                ->where('sdate', '>=', $request->start_date)
                ->where('edate', '<=', $request->end_date)->sum('profit');
            array_push($salesBranchReport, $salesBrRep);
        }
        return view('reports.BranchGrossReport', compact('start_date', 'end_date', 'date', 'salesReport', 'branchArray',
            'grand_amt', 'grand_cost', 'grand_profit', 'salesBranchReport'));
    }
    public function storeVettotb($upd_id, $str_id, $amount, $discount, $cost, $vat, $gldept, $sdate, $edate, $updateOnly)
    {
        if ($updateOnly == 'Y') {
            $vettotb = Vettotb::find($upd_id);
            $vettotb->amount = $vettotb->amount + $amount;
            $vettotb->discount = $vettotb->discount + $discount;
            $vettotb->cost = $vettotb->cost + $cost;
            $vettotb->vat = $vettotb->vat + $vat;
            $vettotb->profit = $vettotb->profit + (($amount + $discount) - $cost);
            $vettotb->update();
        } else {
            $vettotb = new Vettotb();
            $date = Carbon::now();
            $vettotb->amount = $amount;
            $vettotb->discount = $discount;
            $vettotb->sdate = $sdate;
            $vettotb->stime = $date->format('H:m:s');
            $vettotb->edate = $edate;
            $vettotb->etime = $date->format('H:m:s');
            $vettotb->vat = $vat;
            $vettotb->cost = $cost;
            $vettotb->profit = ($amount + $discount) - $cost;
            $vettotb->adj = 0;
            $vettotb->branch_id = $gldept;
            $vettotb->type_id = $str_id;
            $vettotb->save();
        }
    }
    public function transactionTimeline()
    {
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();
        $reps = Vetuser::where('id', '>', 0)->orderby('user_code', 'asc')->get();

        return view('reports.TransactionTimeline', compact('branches', 'reps'));
    }
    public function timelineReport(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->end_date < $request->start_date)
            return Redirect::route('TransactionTimeline')->withInput()->with('danger', 'End Date cannot be less than Start Date');

        if ($request->branch_id == null) {
            $branches = Branch::where('id', '!=', null)
                ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();
            $branch_name = 'All Branches';
        } else {
            $branches = Branch::where('id', '=', $request->branch_id)->get();
            $b = Branch::where('id', '=', $request->branch_id)->first();
            $branch_name = $b->description;
        }

        if ($request->user_code == null)
            $vets = Vetuser::where('id', '>', 0)->orderBy('user_code', 'asc')->get();
        else
            $vets = Vetuser::where('user_code', '=', $request->user_code)->get();

        $sDate = date('d/m/Y', strtotime($request->start_date));
        $eDate = date('d/m/Y', strtotime($request->end_date));
        $date = Carbon::now();
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;
        DB::table($name . '.' . 'timeline')->truncate();

        $cType = Type::where('type', '=', 'C')->first();
        $iType = Type::where('type', '=', 'I')->first();
        foreach ($branches as $branch)
        {
            foreach ($vets as $vet)
            {
                $dompojb = DB::select("select dpojb_date, dpojb_time, rep, secs, customer, invoice, ref, amount, tax_amount,
                    dis_amount, type_id, branch_id from $name.dompojb where dpojb_date >= '$request->start_date' and 
                    dpojb_date <= '$request->end_date' and rep = '$vet->user_code' and (type_id = $cType->id or type_id = 
                    $iType->id) and branch_id = '$branch->id' order by dpojb_time asc");

                foreach ($dompojb as $dompoj) {
                     $table = 'dom';
                    $this->insertTimeline($dompoj, $table);
                }
                $curbatch = DB::select("select dbat_date, dbat_time, rep, secs, customer, invoice, ref, amount, tax_amount,
                    dis_amount, type_id, branch_id from $name.curbatch where dbat_date >= '$request->start_date' and 
                    dbat_date <= '$request->end_date' and rep = '$vet->user_code' and (type_id = $cType->id or type_id = 
                    $iType->id) and branch_id = '$branch->id' order by dbat_time asc");

                foreach ($curbatch as $curbat) {
                    $table = 'cur';
                    $this->insertTimeline($curbat, $table);
                }
                $cancels = DB::select("select cotra_date, cotra_time, rep, customer, invnum, description, amount, discount,
                    tax, branch_id from $name.cancels where cotra_date >= '$request->start_date' and 
                    cotra_date <= '$request->end_date' and rep = '$vet->user_code' and branch_id = '$branch->id' order 
                    by cotra_time asc");

                foreach ($cancels as $cancel) {
                    $table = 'can';
                    $this->insertTimeline($cancel, $table);
                }
            }
        }
        $vetUsers = DB::select("select t_time as t_time, rep, type, sum(amount) as amount, user_name from $name.timeline, 
            $name.vetusers where rep = user_code group by t_time, rep, type, user_name order by t_time asc");
        $timeline = Timeline::where('t_date', '>=', $request->start_date)
            ->where('t_date', '<=', $request->end_date)->orderBy('t_time', 'asc')->get();
        $timelineArray = array();
        $inv_tot = 0; $vet = null;
        foreach ($timeline as $item)
        {
            $timelineReport = new TimelineReport();
            switch ($item->type) {
                case 'R':
                    $timelineReport->type = 'Receipt';
                    break;
                case 'I':
                    $timelineReport->type = 'Normal Inv';
                    $inv_tot = $inv_tot + $item->amount;
                    break;
                case 'C':
                    $timelineReport->type = 'Cancelled Inv';
                    $inv_tot = $inv_tot + $item->amount;
                    break;
            }
            $timelineReport->dept = $item->branch_id;
            $timelineReport->customer = $item->customer;
            $timelineReport->rep = $item->rep;
            $timelineReport->doc = $item->doc;
            $timelineReport->date = date('d/m/Y', strtotime($item->t_date));
            $timelineReport->time = $item->t_time;
            $timelineReport->secs = $item->sec;
            $client = Client::where('customer', '=', $item->customer)->first();
            $timelineReport->ref = 'Client';
            $timelineReport->name = $client->initials . ' ' . $client->surname;
            $timelineReport->stock = $item->ref;
            $timelineReport->amount = $item->amount;
            array_push($timelineArray, $timelineReport);
        }
        return view('reports.TransactionTimelineReport', compact('branch_name', 'sDate', 'eDate', 'date', 'timelineArray',
            'vetUsers'));
    }
    public function insertTimeline($record, $table)
    {
        $timeline = new Timeline();
        if ($table == 'dom') {
            $timeline->t_date = $record->dpojb_date;
            $time = Carbon::createFromFormat('H:i:s', $record->dpojb_time)->format('H:i');
            $timeline->t_time = $time;
            $timeline->sec = $record->secs;
            $timeline->doc = $record->invoice;
            $timeline->ref = $record->ref;
            $timeline->amount = $record->amount + $record->tax_amount + $record->dis_amount;
            if ($record->type_id == 8)
                $timeline->type = 'R';
            else
                $timeline->type = 'I';
        } elseif ($table == 'cur') {
            $timeline->t_date = $record->dbat_date;
            $time = Carbon::createFromFormat('H:i:s', $record->dbat_time)->format('h:i');
            $timeline->t_time = $time;
            $timeline->sec = $record->secs;
            $timeline->doc = $record->invoice;
            $timeline->ref = $record->ref;
            $timeline->amount = $record->amount + $record->tax_amount + $record->dis_amount;
            if ($record->type_id == 8)
                $timeline->type = 'R';
            else
                $timeline->type = 'I';
        } else {
            $timeline->t_date = $record->cotra_date;
            $time = Carbon::createFromFormat('H:i:s', $record->cotra_time)->format('h:i');
            $timeline->t_time = $time;
            $timeline->sec = 0;
            $timeline->doc = $record->invnum;
            $timeline->ref = $record->description;
            $timeline->type = 'C';
            $timeline->amount = $record->amount + $record->discount + $record->tax;
        }
        $timeline->rep = $record->rep;
        $timeline->index = $timeline->index + 1;
        $timeline->customer = $record->customer;
        $timeline->branch_id = $record->branch_id;
        $timeline->save();
    }
    public function notBarcodedReport()
    {
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;
        $date = Carbon::now();

        $sql = ("select c.description as codedescr, uom, barcode, type_id, type, t.description as typedescr from 
        $name.codes c, $name.types t where type_id = t.id order by type asc, c.description asc");
        $codes = DB::select($sql);
        $type = null;
        $typeArray = array();
        $codeArray = array();

        foreach ($codes as $code)
        {
            $contains = Str::contains($code->codedescr, ['ZZZ SYSTEM CODE']);
            if ($contains == true)
                continue;

            if ($code->type != 'M' && $code->type != 'J' && $code->type != 'H' && $code->type != 'G' && $code->type != 'L'
                && $code->type != 'X' && $code->type != 'V' && $code->type != 'K' && $code->type != 'L')
                continue;

            if ($code->codedescr == '                              ')
                continue;

            if ($code->type != $type) {
                $types = new Types();
                $types->type = $code->type;
                $types->description = $code->typedescr;
                array_push($typeArray, $types);
            }
            if ($code->barcode == '                    ') {
                $notBarcoded = new NotBarcoded();
                $notBarcoded->type = $code->type;
                $notBarcoded->description = $code->codedescr;
                $notBarcoded->uom = $code->uom;
                array_push($codeArray, $notBarcoded);
            }
            $type = $code->type;
        }
        return view('reports.NotBarcodedReport', compact('date', 'typeArray', 'codeArray'));
    }
    public function outstandingDebt()
    {
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;
        $date = Carbon::now();

        $sql = ("select description, sum(current + age30 + age60 + age90 + age120) as balance, sum(current) as
            current, sum(age30) as age30, sum(age60) as age60, sum(age90) as age90, sum(age120) as age120 from 
            $name.branches, $name.clients where id = branch_id group by description order by description asc");
        $totalDebts = DB::select($sql);

        return view('reports.TotalOutstandingDebt', compact('date', 'totalDebts'));
    }
    public function patientSpecies()
    {
        $types = PatientType::where('id', '>', 0)->get();
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.PatientSpecies', compact('types', 'branches'));
    }
    public function patientSpeciesReport(Request $request)
    {
        ini_set('max_execution_time', '-1');
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();
        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;

        $gender = $request->gender;
        $min_age = $request->min_age;
        $max_age = $request->max_age;
        $min_weight = $request->min_weight;
        $max_weight = $request->max_weight;

        if ($request->active_clients == 'on')
            $client_status = 'Y';
        else
            $client_status = 'N';

        $last_seen = date('d/m/Y', strtotime($request->last_seen));
        $date = Carbon::now();

        $species = PatientType::where('id', '=', $request->patType_id)->first();
        $patientBuild = Patient::where('type', '=', $species->type)
            ->where('last_seen', '<=', $request->last_seen)
            ->where('dead', '!=', 'Y')
            ->where('mass', '>=', $request->min_weight);

        if ($request->gender != null && $request->gender != 'A')
            $patientBuild = $patientBuild->where('sex', '=', $request->gender);

        if ($request->active_patients == 'on') {
            $patientBuild = $patientBuild->where('active', '=', 'Y');
            $patient_status = 'Y';
        } else {
            $patientBuild = $patientBuild->where('active', '!=', 'Y');
            $patient_status = 'N';
        }
        if ($request->branch_id != null)
            $patientBuild = $patientBuild->where('branch_id', '=', $request->branch_id);

        $patients = $patientBuild->get();

        $age = null;
        $patientArray = array();
        foreach ($patients as $patient)
        {
            $age = ($date->diffInDays($patient->dob)) / 365;
            if ($age < $request->min_age or $age > $request->max_age)
                continue;

            if ($patient->mass > $request->max_weight)
                continue;

            $patientWeight = new PatientWeight();
            $patientWeight->patient = $patient->patient;
            $patientWeight->name = $patient->name;
            $patientWeight->breed = $patient->breed;
            $patientWeight->sex = $patient->sex;
            $patientWeight->age = $age;
            $patientWeight->weight = $patient->mass;
            $patientWeight->active = $patient->active;
            if ($request->print_details == 'on')
            {
                if ($request->active_clients == 'on')
                    $sql = ("select c.customer, title, surname, address1, address2, address3, code, hometel, work_tel, 
                        cell2, paddress1, paddress2, paddress3, pcode, cell1, email, last_seen from $name.clients c, 
                        $name.patient_client pc where pc.patient = $patient->patient and pc.customer = c.customer and 
                        active = 'Y'");
                else
                    $sql = ("select c.customer, title, surname, address1, address2, address3, code, hometel, work_tel, 
                        cell2, paddress1, paddress2, paddress3, pcode, cell1, email, last_seen from $name.clients c, 
                        $name.patient_client pc where pc.patient = $patient->patient and pc.customer = c.customer and 
                        active != 'Y'");
                $clients = DB::select($sql);
                foreach ($clients as $client) {
                    $patientWeight->customer = $client->customer;
                    $patientWeight->client = $client->title . $client->surname;
                    if ($client->address1 != null && $client->address1 != '                              ') {
                        $patientWeight->address1 = $client->address1;
                        $patientWeight->address2 = $client->address2;
                        $patientWeight->address3 = $client->address3;
                        $patientWeight->post_code = $client->code;
                    } else {
                        $patientWeight->address1 = $client->paddress1;
                        $patientWeight->address2 = $client->paddress2;
                        $patientWeight->address3 = $client->paddress3;
                        $patientWeight->post_code = $client->pcode;
                    }
                    if ($client->hometel != null && $client->hometel = '            ')
                        $patientWeight->telNo = $client->hometel;
                    else
                        $patientWeight->telNo = $client->work_tel;

                    if ($client->cell1 != null && $client->cell1 = '            ')
                        $patientWeight->mobileNo = $client->cell1;
                    else
                        $patientWeight->mobileNo = $client->cell2;

                    $patientWeight->email = $client->email;
                    $patientWeight->last_seen = $client->last_seen;
                }
            }
            array_push($patientArray, $patientWeight);
        }
        if ($request->print_details == null)
            return view('reports.PatientSpeciesReport', compact('species', 'gender', 'min_age', 'max_age', 'min_weight',
                'max_weight', 'patient_status', 'client_status', 'last_seen', 'date', 'patientArray'));
        else
            return view('reports.PatientSpeciesReport2', compact('species', 'gender', 'min_age', 'max_age', 'min_weight',
                'max_weight', 'patient_status', 'client_status', 'last_seen', 'date', 'patientArray'));
    }
}
class LowSalesSummary
{
    public  $id;
    public $description;
    public $qty_sold;
    public $last_sale;
    public $no_sales;
    public $cost_price;
    public $sales_price;
    public $on_hand;
    public $sales_valuation;
    public $cost_valuation;
}
class VATReport
{
    public $id;
    public $adjBatch;
    public $vatAsd;
    public $vatAed;
    public $receiptBatch;
    public $vatRsd;
    public $vatRed;
    public $invoiceBatch;
    public $vatIsd;
    public $vatIed;
    public $interestBatch;
    public $vatInsd;
    public $vatIned;
    public $accom;
    public $accom_amt;
    public $accom_perc;
    public $disp;
    public $disp_amt;
    public $disp_perc;
    public $trav;
    public $trav_amt;
    public $trav_perc;
    public $med;
    public $med_amt;
    public $med_perc;
    public $cons;
    public $cons_amt;
    public $cons_perc;
    public $lab;
    public $lab_amt;
    public $lab_perc;
    public $xray;
    public $xray_amt;
    public $xray_perc;
    public $inj;
    public $inj_amt;
    public $inj_perc;
    public $proc;
    public $proc_amt;
    public $proc_perc;
    public $surg;
    public $surg_amt;
    public $surg_perc;
    public $vacc;
    public $vacc_amt;
    public $vacc_perc;
    public $hosp;
    public $hosp_amt;
    public $hosp_perc;
    public $merch;
    public $merch_amt;
    public $merch_perc;
    public $food;
    public $food_amt;
    public $food_perc;
    public $dent;
    public $dent_amt;
    public $dent_perc;
    public $grom;
    public $grom_amt;
    public $grom_perc;
    public $gen;
    public $gen_amt;
    public $gen_perc;
    public $inv_disc;
    public $inv_amt;
    public $inv_perc;
    public $unknown;
    public $unknown_amt;
    public $unknown_perc;
    public $totInvoiced;
    public $totInvAmt;
    public $baseInvoice;
    public $baseInvAmt;
    public $lessDisc;
    public $lessDiscAmt;
    public $subTot;
    public $subTotal;
    public $addVAT;
    public $addVATInv;
    public $contrTot;
    public $contrTotal;
    public $adjust;
    public $adjustment;
    public $adjustVAT;
    public $adjustmentVAT;
    public $invoiceTot;
    public $invoiceTotal;
    public $zeroRating;
    public $zeroRatingAmt;
    public $zeroDiscount;
    public $zeroRatingDiscount;
    public $zeroTotal;
    public $zeroRatingTotal;
    public $exempt;
    public $exemptAmount;
    public $exemptDiscount;
    public $exemptAmtDiscount;
    public $exemptTotal;
    public $exemptAmtTotal;
    public $receiptSummary;
    public $receipts;
    public $totalReceipts;
    public $lessDiscount;
    public $lessReceiptDisc;
    public $sub;
    public $subTotal2;
    public $lessVAT;
    public $lessVATRecover;
    public $actual;
    public $actualReceipts;
    public $adjustSummary;
    public $adjustSum;
    public $VATAdjustments;
    public $VATAdjust;
    public $totAdjust;
    public $totalAdjustments;
    public $interestSummary;
    public $interest;
    public $interestCharged;
    public $accounting;
    public $accountingFee;
    public $VATAccounting;
    public $VATAccountingFee;
    public $totCharges;
    public $totalCharges;
    public $netDebtors;
    public $netDebtorsChange;
}
class SalesReport
{
    public $vet;
    public $type;
    public $amount;
    public $discount;
    public $cost;
    public $gross;
    public $adjust;
    public $net;
    public $VAT;
}
class SalesBranchRep
{
    public $type;
    public $amount;
    public $discount;
    public $cost;
    public $gross;
    public $adjust;
    public $net;
}
class SchedDrugs
{
    public $description;
    public $uom;
    public $schedule;
    public $code;
    public $stock_date;
    public $quantity_on_hand;
    public $customer;
    public $patient;
    public $patName;
    public $date_dispensed;
    public $qty;
    public $balance;
}
class DailyStockTracker
{
    public $stock_date;
    public $opening_qty;
    public $sold_qty;
    public $received_qty;
    public $adjusted_qty;
    public $returned_qty;
    public $closing_qty;
}
class Adjustments
{
    public $adjust_date;
    public $adjust_rec;
}
class SalesTotals
{
    public $id;
    public $description;
    public $item;
    public $qty;
    public $mass;
    public $cost;
    public $sales;
    public $discount;
    public $profit;
}
class VetTotals
{
    public $branch_id;
    public $vet_code;
    public $vet_name;
    public $vet_amt;
    public $vet_discount;
    public $vet_cost;
    public $vet_gross;
    public $vet_adjust;
    public $vet_net;
    public $vet_vat;
}
class BranchTotals
{
    public $branch_id;
    public $branch_name;
    public $branch_amt;
    public $branch_discount;
    public $branch_cost;
    public $branch_gross;
    public $branch_adjust;
    public $branch_net;
    public $branch_vat;
}
class TimelineReport
{
    public $type;
    public $rep;
    public $customer;
    public $dept;
    PUBLIC $doc;
    public $date;
    public $time;
    public $secs;
    public $ref;
    public $name;
    public $stock;
    public $amount;
}
class VetsTotals
{
    public $vet;
    public $vetName;
    public $total;
}
class Types
{
    public $type;
    public $description;
}
class NotBarcoded
{
    public $type;
    public $description;
    public $uom;
}
class PatientWeight
{
    public $patient;
    public $name;
    public $breed;
    public $sex;
    public $age;
    public $weight;
    public $active;
    public $customer;
    public $client;
    public $address1;
    public $address2;
    public $address3;
    public $post_code;
    public $telNo;
    public $mobileNo;
    public $email;
    public $last_seen;
}
