<?php

namespace App\Http\Controllers;

use App\Models\EID;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;

class EIDController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $eids = EID::where('status', '=', 'A')->get();
        return view('eid.index', compact('eids'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('eid.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $eid = EID::where('name', '=', $request->name)->count();
        if ($eid > 0)
            return redirect('eid/create')->withInput()->with('danger', 'Enterprise already exists');

        $input = $request->all();
        $eids = new EID($input);
        $eids->schemaName = $request->schemaName;

        if ($eids->save())
            return Redirect::route('eids')->with('success', 'Successfully added enterprise');
        else
            return Redirect::route('addEID')->withInput()->withErrors($eids->errors());
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\EID  $eID
     * @return \Illuminate\Http\Response
     */
    public function show(EID $eID)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\EID  $eID
     * @return \Illuminate\Http\Response
     */
    public function edit(EID $eID, $id)
    {
        $eid = EID::find($id);
        return view('eid.edit', ['eid' => $eid]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\EID  $eID
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, EID $eID, $id)
    {
        $eid = EID::find($id);
        $eid_check = EID::where('name', '=', $request->name)->get()->first();

        if ($eid_check && $eid_check->id != $id)
            return Redirect::route('editEID', [$id])->withInput()->with('danger', 'eid already exists');

        $eid->name = $request->name;
        $eid->enterprise_id = $request->enterprise_id;
        $eid->schemaName = $request->schemaName;

        if ($eid->update())
            return Redirect::route('eids')->with('success', 'Successfully updated eid');
        else
            return Redirect::route('editEID', [$id])->withInput()->withErrors($eid->errors());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\EID  $eID
     * @return \Illuminate\Http\Response
     */
    public function destroy(EID $eID, $id)
    {
        $eid = EID::findOrFail($id);
        $eid->status = 'I';
        if ($eid->update());
            return Redirect::route('eids')->with('success', 'eid successfully de-activated');
    }
}
